/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8;

import android.net.Uri;
import android.text.TextUtils;
import com.arialyy.aria.core.common.RequestEnum;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.task.AbsThreadTaskAdapter;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaM3U8Exception;
import com.arialyy.aria.http.ConnectionHelp;
import com.arialyy.aria.http.HttpTaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.CommonUtil;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Map;
import java.util.Set;

public final class M3U8ThreadTaskAdapter
extends AbsThreadTaskAdapter {
    private final String TAG = CommonUtil.getClassName((Object)((Object)this));
    private HttpTaskOption mHttpTaskOption = (HttpTaskOption)this.getTaskWrapper().getTaskOption();
    private BufferedInputStream is = null;

    public M3U8ThreadTaskAdapter(SubThreadConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlerThreadTask() {
        if (this.getThreadRecord().isComplete) {
            this.handleComplete();
            return;
        }
        HttpURLConnection conn = null;
        try {
            Map params;
            URL url = ConnectionHelp.handleUrl((String)this.getThreadConfig().url, (HttpTaskOption)this.mHttpTaskOption);
            conn = ConnectionHelp.handleConnection((URL)url, (HttpTaskOption)this.mHttpTaskOption);
            ALog.d((String)this.TAG, (String)String.format("\u5206\u7247\u3010%s\u3011\u5f00\u59cb\u4e0b\u8f7d", this.getThreadRecord().threadId));
            if (this.mHttpTaskOption.isChunked()) {
                conn.setDoInput(true);
                conn.setChunkedStreamingMode(0);
            }
            if (this.mHttpTaskOption.getRequestEnum() == RequestEnum.POST && (params = this.mHttpTaskOption.getParams()) != null) {
                OutputStreamWriter dos = new OutputStreamWriter(conn.getOutputStream());
                Set keys = params.keySet();
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    sb.append(key).append("=").append(URLEncoder.encode((String)params.get(key))).append("&");
                }
                String paramStr = sb.toString();
                paramStr = paramStr.substring(0, paramStr.length() - 1);
                dos.write(paramStr);
                dos.flush();
                dos.close();
            }
            this.handleConn(conn);
        }
        catch (MalformedURLException e) {
            this.fail((AriaException)new AriaM3U8Exception(String.format("\u5206\u7247\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getThreadRecord().threadId, this.getThreadConfig().tempFile.getPath(), this.getEntity().getUrl()), (Exception)e), false);
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaM3U8Exception(String.format("\u5206\u7247\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getThreadRecord().threadId, this.getThreadConfig().tempFile.getPath(), this.getEntity().getUrl()), (Exception)e), true);
        }
        catch (Exception e) {
            this.fail((AriaException)new AriaM3U8Exception(String.format("\u5206\u7247\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25\uff0cfilePath: %s, url: %s", this.getThreadRecord().threadId, this.getThreadConfig().tempFile.getPath(), this.getEntity().getUrl()), e), false);
        }
        finally {
            try {
                if (this.is != null) {
                    this.is.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleConn(HttpURLConnection conn) throws IOException {
        ConnectionHelp.setConnectParam((HttpTaskOption)this.mHttpTaskOption, (HttpURLConnection)conn);
        conn.setConnectTimeout(this.getTaskConfig().getConnectTimeOut());
        conn.setReadTimeout(this.getTaskConfig().getIOTimeOut());
        conn.connect();
        int code = conn.getResponseCode();
        if (code == 200) {
            this.is = new BufferedInputStream(ConnectionHelp.convertInputStream((HttpURLConnection)conn));
            if (this.mHttpTaskOption.isChunked()) {
                this.readChunked(this.is);
            } else if (this.getThreadConfig().isBlock) {
                this.readDynamicFile(this.is);
            }
        } else if (code == 302 || code == 301 || code == 303 || code == 201 || code == 307) {
            this.handleUrlReTurn(conn, conn.getHeaderField("Location"));
        } else {
            this.fail((AriaException)new AriaM3U8Exception(String.format("\u8fde\u63a5\u9519\u8bef\uff0chttp\u9519\u8bef\u7801\uff1a%s\uff0curl\uff1a%s", code, this.getThreadConfig().url)), false);
        }
        conn.disconnect();
    }

    private void handleUrlReTurn(HttpURLConnection conn, String newUrl) throws IOException {
        ALog.d((String)this.TAG, (String)("30x\u8df3\u8f6c\uff0c\u65b0url\u4e3a\u3010" + newUrl + "\u3011"));
        if (TextUtils.isEmpty((CharSequence)newUrl) || newUrl.equalsIgnoreCase("null")) {
            this.fail((AriaException)new AriaM3U8Exception("\u4e0b\u8f7d\u5931\u8d25\uff0c\u91cd\u5b9a\u5411url\u4e3a\u7a7a"), false);
            return;
        }
        if (newUrl.startsWith("/")) {
            Uri uri = Uri.parse((String)this.getThreadConfig().url);
            newUrl = uri.getHost() + newUrl;
        }
        if (!CheckUtil.checkUrl((String)newUrl)) {
            this.fail((AriaException)new AriaM3U8Exception("\u4e0b\u8f7d\u5931\u8d25\uff0c\u91cd\u5b9a\u5411url\u9519\u8bef"), false);
            return;
        }
        String cookies = conn.getHeaderField("Set-Cookie");
        conn.disconnect();
        URL url = ConnectionHelp.handleUrl((String)newUrl, (HttpTaskOption)this.mHttpTaskOption);
        conn = ConnectionHelp.handleConnection((URL)url, (HttpTaskOption)this.mHttpTaskOption);
        if (!TextUtils.isEmpty((CharSequence)cookies)) {
            conn.setRequestProperty("Cookie", cookies);
        }
        if (this.mHttpTaskOption.isChunked()) {
            conn.setDoInput(true);
            conn.setChunkedStreamingMode(0);
        }
        this.handleConn(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readChunked(InputStream is) {
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(this.getThreadConfig().tempFile, true);
            byte[] buffer = new byte[this.getTaskConfig().getBuffSize()];
            while (this.getThreadTask().isLive() && (len = is.read(buffer)) != -1 && !this.getThreadTask().isBreak()) {
                if (this.mSpeedBandUtil != null) {
                    this.mSpeedBandUtil.limitNextBytes(len);
                }
                fos.write(buffer, 0, len);
                this.progress(len);
            }
            this.handleComplete();
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaM3U8Exception(String.format("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0csavePath: %s, url: %s", this.getThreadConfig().tempFile.getPath(), this.getThreadConfig().url), (Exception)e), true);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDynamicFile(InputStream is) {
        OutputStream fos = null;
        AbstractInterruptibleChannel foc = null;
        Channel fic = null;
        try {
            int len;
            fos = new FileOutputStream(this.getThreadConfig().tempFile, true);
            foc = ((FileOutputStream)fos).getChannel();
            fic = Channels.newChannel(is);
            ByteBuffer bf = ByteBuffer.allocate(this.getTaskConfig().getBuffSize());
            while (this.getThreadTask().isLive() && (len = fic.read(bf)) != -1 && !this.getThreadTask().isBreak()) {
                if (this.mSpeedBandUtil != null) {
                    this.mSpeedBandUtil.limitNextBytes(len);
                }
                bf.flip();
                ((FileChannel)foc).write(bf);
                bf.compact();
                this.progress(len);
            }
            this.handleComplete();
        }
        catch (IOException e) {
            this.fail((AriaException)new AriaM3U8Exception(String.format("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0csavePath: %s, url: %s", this.getThreadConfig().tempFile.getPath(), this.getThreadConfig().url), (Exception)e), true);
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                if (foc != null) {
                    foc.close();
                }
                if (fic != null) {
                    fic.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private DownloadEntity getEntity() {
        return (DownloadEntity)this.getTaskWrapper().getEntity();
    }

    private void handleComplete() {
        if (this.getThreadTask().isBreak()) {
            return;
        }
        this.complete();
    }
}

