/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8.live;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.m3u8.M3U8Listener;
import com.arialyy.aria.m3u8.M3U8TaskOption;
import com.arialyy.aria.m3u8.live.M3U8LiveLoader;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;

final class LiveStateManager
implements IThreadStateManager {
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private M3U8Listener mListener;
    private long mProgress;
    private Looper mLooper;
    private DTaskWrapper mTaskWrapper;
    private M3U8TaskOption mM3U8Option;
    private FileOutputStream mIndexFos;
    private M3U8LiveLoader mLoader;
    private Handler.Callback mCallback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            int peerIndex = msg.getData().getInt("DATA_M3U8_PEER_INDEX");
            switch (msg.what) {
                case 1: {
                    if (!LiveStateManager.this.mLoader.isBreak()) break;
                    ALog.d((String)LiveStateManager.this.TAG, (String)"\u4efb\u52a1\u505c\u6b62");
                    LiveStateManager.this.quitLooper();
                    break;
                }
                case 3: {
                    if (!LiveStateManager.this.mLoader.isBreak()) break;
                    ALog.d((String)LiveStateManager.this.TAG, (String)"\u4efb\u52a1\u53d6\u6d88");
                    LiveStateManager.this.quitLooper();
                    break;
                }
                case 4: {
                    LiveStateManager.this.mLoader.notifyLock(true, peerIndex);
                    if (LiveStateManager.this.mM3U8Option.isGenerateIndexFile() && !LiveStateManager.this.mLoader.isBreak()) {
                        LiveStateManager.this.addExtInf(((LiveStateManager)LiveStateManager.this).mLoader.getCurExtInfo().url, ((LiveStateManager)LiveStateManager.this).mLoader.getCurExtInfo().extInf);
                    }
                    LiveStateManager.this.mListener.onPeerComplete(LiveStateManager.this.mTaskWrapper.getKey(), msg.getData().getString("DATA_M3U8_PEER_PATH"), peerIndex);
                    break;
                }
                case 5: {
                    Bundle b = msg.getData();
                    if (b == null) break;
                    long len = b.getLong("DATA_ADD_LEN", 0L);
                    LiveStateManager.this.mProgress = LiveStateManager.this.mProgress + len;
                    break;
                }
                case 2: {
                    LiveStateManager.this.mLoader.notifyLock(false, peerIndex);
                    LiveStateManager.this.mListener.onPeerFail(LiveStateManager.this.mTaskWrapper.getKey(), msg.getData().getString("DATA_M3U8_PEER_PATH"), peerIndex);
                }
            }
            return true;
        }
    };

    LiveStateManager(DTaskWrapper wrapper, IEventListener listener) {
        this.mTaskWrapper = wrapper;
        this.mListener = (M3U8Listener)listener;
        this.mM3U8Option = (M3U8TaskOption)this.mTaskWrapper.getM3u8Option();
    }

    void setLoader(M3U8LiveLoader loader) {
        this.mLoader = loader;
    }

    private void quitLooper() {
        ALog.d((String)this.TAG, (String)"quitLooper");
        this.mLooper.quit();
        if (this.mIndexFos != null) {
            try {
                this.mIndexFos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void addExtInf(String url, String extInf) {
        File indexFile = new File(String.format("%s.index", ((DownloadEntity)this.mTaskWrapper.getEntity()).getFilePath()));
        if (!indexFile.exists()) {
            ALog.e((String)this.TAG, (String)String.format("\u7d22\u5f15\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u6dfb\u52a0peer\u7684extInf\u5931\u8d25", indexFile.getPath()));
            return;
        }
        try {
            if (this.mIndexFos == null) {
                this.mIndexFos = new FileOutputStream(indexFile, true);
            }
            this.mIndexFos.write(extInf.concat("\r\n").getBytes(Charset.forName("UTF-8")));
            this.mIndexFos.write(url.concat("\r\n").getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isFail() {
        return false;
    }

    public boolean isComplete() {
        return false;
    }

    public long getCurrentProgress() {
        return this.mProgress;
    }

    public void updateCurrentProgress(long currentProgress) {
        this.mProgress = currentProgress;
    }

    public void setLooper(TaskRecord taskRecord, Looper looper) {
        this.mLooper = looper;
    }

    public Handler.Callback getHandlerCallback() {
        return this.mCallback;
    }

    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent((IThreadStateManager)this);
    }
}

