/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8.live;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.loader.IThreadTaskBuilder;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.processor.ITsMergeHandler;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.task.IThreadTaskAdapter;
import com.arialyy.aria.core.task.ThreadTask;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaM3U8Exception;
import com.arialyy.aria.m3u8.BaseM3U8Loader;
import com.arialyy.aria.m3u8.IdGenerator;
import com.arialyy.aria.m3u8.M3U8InfoTask;
import com.arialyy.aria.m3u8.M3U8Listener;
import com.arialyy.aria.m3u8.M3U8TaskOption;
import com.arialyy.aria.m3u8.M3U8ThreadTaskAdapter;
import com.arialyy.aria.m3u8.live.LiveRecordHandler;
import com.arialyy.aria.m3u8.live.LiveStateManager;
import com.arialyy.aria.m3u8.live.LiveTsDefConverter;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class M3U8LiveLoader
extends BaseM3U8Loader {
    private static int EXEC_MAX_NUM = 4;
    private Handler mStateHandler;
    private ArrayBlockingQueue<Long> mFlagQueue = new ArrayBlockingQueue(EXEC_MAX_NUM);
    private ReentrantLock LOCK = new ReentrantLock();
    private Condition mCondition = this.LOCK.newCondition();
    private LinkedBlockingQueue<ExtInfo> mPeerQueue = new LinkedBlockingQueue();
    private ExtInfo mCurExtInfo;
    private M3U8InfoTask mInfoTask;
    private ScheduledThreadPoolExecutor mTimer;
    private List<String> mPeerUrls = new ArrayList<String>();

    M3U8LiveLoader(DTaskWrapper wrapper, M3U8Listener listener) {
        super(wrapper, (IEventListener)listener);
        if (((M3U8TaskOption)wrapper.getM3u8Option()).isGenerateIndexFile()) {
            ALog.i((String)this.TAG, (String)"\u76f4\u64ad\u6587\u4ef6\u4e0b\u8f7d\uff0c\u521b\u5efa\u7d22\u5f15\u6587\u4ef6\u7684\u64cd\u4f5c\u5c06\u5bfc\u81f4\u53ea\u80fd\u540c\u65f6\u4e0b\u8f7d\u4e00\u4e2a\u5207\u7247");
            EXEC_MAX_NUM = 1;
        }
    }

    ExtInfo getCurExtInfo() {
        return this.mCurExtInfo;
    }

    private void offerPeer(ExtInfo extInfo) {
        this.mPeerQueue.offer(extInfo);
    }

    protected void handleTask(Looper looper) {
        if (this.isBreak()) {
            return;
        }
        this.getRecordHandler().setOption(this.mM3U8Option);
        this.mRecord = this.getRecordHandler().getRecord(0L);
        this.getStateManager().setLooper(this.mRecord, looper);
        this.getStateManager().setLoader(this);
        this.mStateHandler = new Handler(looper, this.getStateManager().getHandlerCallback());
        this.startLoaderLiveInfo();
        this.startTimer();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String cacheDir = M3U8LiveLoader.this.getCacheDir();
                int index = 0;
                while (!M3U8LiveLoader.this.isBreak()) {
                    try {
                        ExtInfo extInfo;
                        M3U8LiveLoader.this.LOCK.lock();
                        while (M3U8LiveLoader.this.mFlagQueue.size() < EXEC_MAX_NUM && (extInfo = (ExtInfo)M3U8LiveLoader.this.mPeerQueue.poll()) != null) {
                            M3U8LiveLoader.this.mCurExtInfo = extInfo;
                            ThreadTask task = M3U8LiveLoader.this.createThreadTask(cacheDir, index, extInfo.url);
                            M3U8LiveLoader.this.getTaskList().add(task);
                            M3U8LiveLoader.this.mFlagQueue.offer(M3U8LiveLoader.this.startThreadTask(task, task.getConfig().peerIndex));
                            ++index;
                        }
                        if (M3U8LiveLoader.this.mFlagQueue.size() <= 0) continue;
                        M3U8LiveLoader.this.mCondition.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        M3U8LiveLoader.this.LOCK.unlock();
                    }
                }
            }
        }).start();
    }

    protected LiveStateManager getStateManager() {
        return (LiveStateManager)super.getStateManager();
    }

    private LiveRecordHandler getRecordHandler() {
        return (LiveRecordHandler)this.mRecordHandler;
    }

    public long getFileSize() {
        return this.mTempFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyLock(boolean success, int peerId) {
        try {
            this.LOCK.lock();
            long id = this.mFlagQueue.take();
            if (success) {
                ALog.d((String)this.TAG, (String)String.format("\u5207\u7247\u3010%s\u3011\u4e0b\u8f7d\u6210\u529f", peerId));
            } else {
                ALog.e((String)this.TAG, (String)String.format("\u5207\u7247\u3010%s\u3011\u4e0b\u8f7d\u5931\u8d25", peerId));
            }
            this.mCondition.signalAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.LOCK.unlock();
        }
    }

    private long startThreadTask(ThreadTask task, int indexId) {
        ThreadTaskManager.getInstance().startThread(((DTaskWrapper)this.mTaskWrapper).getKey(), (IThreadTask)task);
        ((M3U8Listener)this.getListener()).onPeerStart(((DTaskWrapper)this.mTaskWrapper).getKey(), task.getConfig().tempFile.getPath(), indexId);
        return IdGenerator.getInstance().nextId();
    }

    private ThreadTask createThreadTask(String cacheDir, int indexId, String tsUrl) {
        ThreadRecord tr = this.getRecordHandler().createThreadRecord(this.mRecord, tsUrl, indexId);
        SubThreadConfig config = new SubThreadConfig();
        config.url = tsUrl;
        config.tempFile = new File(M3U8LiveLoader.getTsFilePath(cacheDir, indexId));
        config.isBlock = this.mRecord.isBlock;
        config.taskWrapper = this.mTaskWrapper;
        config.record = tr;
        config.stateHandler = this.mStateHandler;
        config.peerIndex = indexId;
        config.threadType = SubThreadConfig.getThreadType((int)8);
        config.updateInterval = SubThreadConfig.getUpdateInterval((int)8);
        config.ignoreFailure = this.mM3U8Option.isIgnoreFailureTs();
        if (!config.tempFile.exists()) {
            FileUtil.createFile((File)config.tempFile);
        }
        ThreadTask threadTask = new ThreadTask(config);
        M3U8ThreadTaskAdapter adapter = new M3U8ThreadTaskAdapter(config);
        threadTask.setAdapter((IThreadTaskAdapter)adapter);
        return threadTask;
    }

    private boolean mergeFile() {
        String[] tsNames;
        ITsMergeHandler mergeHandler = this.mM3U8Option.getMergeHandler();
        String cacheDir = this.getCacheDir();
        ArrayList<String> partPath = new ArrayList<String>();
        for (String tsName : tsNames = new File(cacheDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ts");
            }
        })) {
            partPath.add(cacheDir + "/" + tsName);
        }
        boolean isSuccess = mergeHandler != null ? mergeHandler.merge(this.getEntity().getM3U8Entity(), partPath) : FileUtil.mergeFile((String)this.getEntity().getFilePath(), partPath);
        if (isSuccess) {
            for (String pp : partPath) {
                FileUtil.deleteFile((String)pp);
            }
            File cDir = new File(cacheDir);
            FileUtil.deleteDir((File)cDir);
            return true;
        }
        ALog.e((String)this.TAG, (String)"\u5408\u5e76\u5931\u8d25");
        return false;
    }

    public void addComponent(IRecordHandler recordHandler) {
        this.mRecordHandler = recordHandler;
    }

    public void addComponent(IInfoTask infoTask) {
        this.mInfoTask = (M3U8InfoTask)infoTask;
        this.mInfoTask.setCallback(new IInfoTask.Callback(){

            public void onSucceed(String key, CompleteInfo info) {
                ALog.d((String)M3U8LiveLoader.this.TAG, (String)"\u66f4\u65b0\u76f4\u64ad\u7684m3u8\u6587\u4ef6");
            }

            public void onFail(AbsEntity entity, AriaException e, boolean needRetry) {
            }
        });
        this.mInfoTask.setOnGetPeerCallback(new M3U8InfoTask.OnGetLivePeerCallback(){

            @Override
            public void onGetPeer(String url, String extInf) {
                LiveTsDefConverter converter;
                if (M3U8LiveLoader.this.mPeerUrls.contains(url)) {
                    return;
                }
                M3U8LiveLoader.this.mPeerUrls.add(url);
                LiveTsDefConverter liveTsDefConverter = converter = M3U8LiveLoader.this.mM3U8Option.isUseDefConvert() ? new LiveTsDefConverter() : M3U8LiveLoader.this.mM3U8Option.getLiveTsUrlConverter();
                if (converter != null) {
                    url = TextUtils.isEmpty((CharSequence)M3U8LiveLoader.this.mM3U8Option.getBandWidthUrl()) ? converter.convert(M3U8LiveLoader.this.getEntity().getUrl(), url) : converter.convert(M3U8LiveLoader.this.mM3U8Option.getBandWidthUrl(), url);
                }
                if (TextUtils.isEmpty((CharSequence)url) || !url.startsWith("http")) {
                    M3U8LiveLoader.this.fail(new AriaM3U8Exception(String.format("ts\u5730\u5740\u9519\u8bef\uff0curl\uff1a%s", url)), false);
                    return;
                }
                M3U8LiveLoader.this.offerPeer(new ExtInfo(url, extInf));
            }
        });
    }

    private void fail(AriaM3U8Exception e, boolean needRetry) {
        this.getListener().onFail(needRetry, (AriaException)e);
        this.handleComplete();
    }

    private void handleComplete() {
        if (this.mInfoTask != null) {
            this.mInfoTask.setStop(true);
            this.closeInfoTimer();
            if (this.mM3U8Option.isGenerateIndexFile()) {
                if (this.generateIndexFile(true)) {
                    this.getListener().onComplete();
                } else {
                    this.getListener().onFail(false, (AriaException)new AriaM3U8Exception("\u521b\u5efa\u7d22\u5f15\u6587\u4ef6\u5931\u8d25"));
                }
            } else if (this.mM3U8Option.isMergeFile()) {
                if (this.mergeFile()) {
                    this.getListener().onComplete();
                } else {
                    this.getListener().onFail(false, (AriaException)new AriaM3U8Exception("\u5408\u5e76\u6587\u4ef6\u5931\u8d25"));
                }
            } else {
                this.getListener().onComplete();
            }
        }
    }

    private void startLoaderLiveInfo() {
        this.mTimer = new ScheduledThreadPoolExecutor(1);
        this.mTimer.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                M3U8LiveLoader.this.mInfoTask.run();
            }
        }, 0L, this.mM3U8Option.getLiveUpdateInterval(), TimeUnit.MILLISECONDS);
    }

    private void closeInfoTimer() {
        if (this.mTimer != null && !this.mTimer.isShutdown()) {
            this.mTimer.shutdown();
        }
    }

    public void addComponent(IThreadStateManager threadState) {
        this.mStateManager = threadState;
    }

    @Deprecated
    public void addComponent(IThreadTaskBuilder builder) {
    }

    protected void checkComponent() {
        if (this.mRecordHandler == null) {
            throw new NullPointerException("\u4efb\u52a1\u8bb0\u5f55\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.mInfoTask == null) {
            throw new NullPointerException("\u6587\u4ef6\u4fe1\u606f\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.mStateManager == null) {
            throw new NullPointerException("\u4efb\u52a1\u72b6\u6001\u7ba1\u7406\u7ec4\u4ef6\u4e3a\u7a7a");
        }
    }

    static class ExtInfo {
        String url;
        String extInf;

        ExtInfo(String url, String extInf) {
            this.url = url;
            this.extInf = extInf;
        }
    }
}

