/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8.vod;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.event.Event;
import com.arialyy.aria.core.event.EventMsgUtil;
import com.arialyy.aria.core.event.PeerIndexEvent;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.loader.IThreadTaskBuilder;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.task.IThreadTaskAdapter;
import com.arialyy.aria.core.task.ThreadTask;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaM3U8Exception;
import com.arialyy.aria.m3u8.BaseM3U8Loader;
import com.arialyy.aria.m3u8.M3U8Listener;
import com.arialyy.aria.m3u8.M3U8TaskOption;
import com.arialyy.aria.m3u8.M3U8ThreadTaskAdapter;
import com.arialyy.aria.m3u8.vod.VodRecordHandler;
import com.arialyy.aria.m3u8.vod.VodStateManager;
import com.arialyy.aria.m3u8.vod.VodTsDefConverter;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class M3U8VodLoader
extends BaseM3U8Loader {
    private int EXEC_MAX_NUM;
    private Handler mStateHandler;
    private ArrayBlockingQueue<TempFlag> mFlagQueue;
    private ArrayBlockingQueue<PeerIndexEvent> mJumpQueue;
    private ReentrantLock LOCK = new ReentrantLock();
    private ReentrantLock EVENT_LOCK = new ReentrantLock();
    private ReentrantLock JUMP_LOCK = new ReentrantLock();
    private Condition mWaitCondition = this.LOCK.newCondition();
    private Condition mEventQueueCondition = this.EVENT_LOCK.newCondition();
    private Condition mJumpCondition = this.JUMP_LOCK.newCondition();
    private SparseArray<ThreadRecord> mBeforePeer = new SparseArray();
    private SparseArray<ThreadRecord> mAfterPeer = new SparseArray();
    private PeerIndexEvent mCurrentEvent;
    private String mCacheDir;
    private AtomicInteger afterPeerIndex = new AtomicInteger();
    private AtomicInteger beforePeerIndex = new AtomicInteger();
    private AtomicInteger mCompleteNum = new AtomicInteger();
    private AtomicInteger mCurrentFlagSize = new AtomicInteger();
    private boolean isJump = false;
    private boolean isDestroy = false;
    private ExecutorService mJumpThreadPool;
    private Thread jumpThread = null;
    private M3U8TaskOption mM3U8Option;
    private Looper mLooper;

    M3U8VodLoader(DTaskWrapper wrapper, M3U8Listener listener) {
        super(wrapper, (IEventListener)listener);
        this.mM3U8Option = (M3U8TaskOption)wrapper.getM3u8Option();
        this.mFlagQueue = new ArrayBlockingQueue(this.mM3U8Option.getMaxTsQueueNum());
        this.EXEC_MAX_NUM = this.mM3U8Option.getMaxTsQueueNum();
        this.mJumpQueue = new ArrayBlockingQueue(10);
        EventMsgUtil.getDefault().register((Object)this);
    }

    protected M3U8Listener getListener() {
        return (M3U8Listener)super.getListener();
    }

    SparseArray<ThreadRecord> getBeforePeer() {
        return this.mBeforePeer;
    }

    int getCompleteNum() {
        return this.mCompleteNum.get();
    }

    void setCompleteNum(int completeNum) {
        this.mCompleteNum.set(completeNum);
    }

    int getCurrentFlagSize() {
        this.mCurrentFlagSize.set(this.mFlagQueue.size());
        return this.mCurrentFlagSize.get();
    }

    void setCurrentFlagSize(int currentFlagSize) {
        this.mCurrentFlagSize.set(currentFlagSize);
    }

    boolean isJump() {
        return this.isJump;
    }

    File getTempFile() {
        return this.mTempFile;
    }

    public void onDestroy() {
        super.onDestroy();
        this.isDestroy = true;
        EventMsgUtil.getDefault().unRegister((Object)this);
        if (this.mJumpThreadPool != null && !this.mJumpThreadPool.isShutdown()) {
            this.mJumpThreadPool.shutdown();
        }
    }

    protected void handleTask(Looper looper) {
        if (this.isBreak()) {
            return;
        }
        this.mLooper = looper;
        this.mInfoTask.run();
    }

    private void startThreadTask() {
        ((VodRecordHandler)this.mRecordHandler).setOption(this.mM3U8Option);
        this.mRecord = this.mRecordHandler.getRecord(0L);
        this.mStateHandler = new Handler(this.mLooper, this.getStateManager().getHandlerCallback());
        this.getStateManager().setVodLoader(this);
        this.getStateManager().setLooper(this.mRecord, this.mLooper);
        this.initData();
        this.startTimer();
        if (this.getStateManager().isComplete()) {
            Log.d((String)this.TAG, (String)"\u4efb\u52a1\u5df2\u5b8c\u6210");
            this.getStateManager().handleTaskComplete();
            return;
        }
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!M3U8VodLoader.this.isBreak()) {
                    try {
                        M3U8VodLoader.this.JUMP_LOCK.lock();
                        if (M3U8VodLoader.this.isJump) {
                            M3U8VodLoader.this.mJumpCondition.await(5L, TimeUnit.SECONDS);
                            M3U8VodLoader.this.isJump = false;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        M3U8VodLoader.this.JUMP_LOCK.unlock();
                    }
                    try {
                        M3U8VodLoader.this.LOCK.lock();
                        while (M3U8VodLoader.this.mFlagQueue.size() < M3U8VodLoader.this.EXEC_MAX_NUM && !M3U8VodLoader.this.isBreak() && M3U8VodLoader.this.mCompleteNum.get() != ((M3U8VodLoader)M3U8VodLoader.this).mRecord.threadRecords.size()) {
                            ThreadRecord tr = M3U8VodLoader.this.getThreadRecord();
                            if (tr == null || tr.isComplete) {
                                ALog.d((String)M3U8VodLoader.this.TAG, (String)"\u8bb0\u5f55\u4e3a\u7a7a\u6216\u8bb0\u5f55\u5df2\u5b8c\u6210");
                                break;
                            }
                            M3U8VodLoader.this.addTaskToQueue(tr);
                        }
                        if (M3U8VodLoader.this.mFlagQueue.size() <= 0) continue;
                        M3U8VodLoader.this.mWaitCondition.await();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        M3U8VodLoader.this.LOCK.unlock();
                    }
                }
            }
        });
        th.start();
    }

    public long getFileSize() {
        return this.getEntity().getFileSize();
    }

    private ThreadRecord getThreadRecord() {
        ThreadRecord tr = null;
        try {
            if (this.beforePeerIndex.get() == 0 && this.afterPeerIndex.get() < this.mAfterPeer.size()) {
                tr = (ThreadRecord)this.mAfterPeer.valueAt(this.afterPeerIndex.get());
                this.afterPeerIndex.getAndIncrement();
            }
            if (this.mBeforePeer.size() > 0 && (tr == null || this.beforePeerIndex.get() != 0) && this.beforePeerIndex.get() < this.mBeforePeer.size()) {
                tr = (ThreadRecord)this.mBeforePeer.valueAt(this.beforePeerIndex.get());
                this.beforePeerIndex.getAndIncrement();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tr;
    }

    private void addTaskToQueue(ThreadRecord tr) throws InterruptedException {
        ThreadTask task = this.createThreadTask(this.mCacheDir, tr, tr.threadId);
        this.getTaskList().add(task);
        this.getEntity().getM3U8Entity().setPeerIndex(tr.threadId);
        TempFlag flag = this.startThreadTask(task, tr.threadId);
        if (flag != null) {
            this.mFlagQueue.put(flag);
        }
    }

    private void initData() {
        this.mCacheDir = this.getCacheDir();
        if (this.mM3U8Option.getJumpIndex() != 0) {
            this.mCurrentEvent = new PeerIndexEvent(((DTaskWrapper)this.mTaskWrapper).getKey(), this.mM3U8Option.getJumpIndex());
            this.resumeTask();
            return;
        }
        this.mCompleteNum.set(0);
        for (ThreadRecord tr : this.mRecord.threadRecords) {
            if (!tr.isComplete) {
                this.mAfterPeer.put(tr.threadId, (Object)tr);
                continue;
            }
            this.mCompleteNum.getAndIncrement();
        }
        this.getStateManager().updateStateCount();
        if (this.mCompleteNum.get() <= 0) {
            this.getListener().onStart(0L);
        } else {
            int percent = this.mCompleteNum.get() * 100 / this.mRecord.threadRecords.size();
            this.getListener().onResume(percent);
        }
    }

    private synchronized void startJumpThread() {
        this.jumpThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!M3U8VodLoader.this.isBreak()) {
                        try {
                            PeerIndexEvent event;
                            M3U8VodLoader.this.EVENT_LOCK.lock();
                            PeerIndexEvent temp = null;
                            while ((event = (PeerIndexEvent)M3U8VodLoader.this.mJumpQueue.poll(1L, TimeUnit.SECONDS)) != null) {
                                temp = event;
                            }
                            if (temp != null) {
                                M3U8VodLoader.this.handleJump(temp);
                            }
                            M3U8VodLoader.this.mEventQueueCondition.await();
                        }
                        finally {
                            M3U8VodLoader.this.EVENT_LOCK.unlock();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.jumpThread.start();
    }

    private void handleJump(PeerIndexEvent event) {
        if (this.isBreak()) {
            ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u5df2\u505c\u6b62\uff0c\u5904\u7406\u8df3\u8f6c\u5931\u8d25");
            return;
        }
        this.mCurrentEvent = event;
        if (this.mRecord == null || this.mRecord.threadRecords == null) {
            ALog.e((String)this.TAG, (String)"\u8df3\u5230\u6307\u5b9a\u4f4d\u7f6e\u5931\u8d25\uff0c\u8bb0\u5f55\u4e3a\u7a7a");
            return;
        }
        if (event.peerIndex >= this.mRecord.threadRecords.size()) {
            ALog.e((String)this.TAG, (String)String.format("\u5207\u7247\u7d22\u5f15\u8bbe\u7f6e\u9519\u8bef\uff0c\u5207\u7247\u6700\u5927\u7d22\u5f15\u4e3a\uff1a%s\uff0c\u5f53\u524d\u8bbe\u7f6e\u7684\u7d22\u5f15\u4e3a\uff1a%s", this.mRecord.threadRecords.size(), event.peerIndex));
            return;
        }
        ALog.i((String)this.TAG, (String)String.format("\u5c06\u4f18\u5148\u4e0b\u8f7d\u7d22\u5f15\u3010%s\u3011\u4e4b\u540e\u7684\u5207\u7247", event.peerIndex));
        this.isJump = true;
        this.notifyWaitLock(false);
        this.mCurrentFlagSize.set(this.mFlagQueue.size());
        try {
            TempFlag flag;
            while ((flag = this.mFlagQueue.poll()) != null) {
                flag.threadTask.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ALog.d((String)this.TAG, (String)"\u5b8c\u6210\u505c\u6b62\u961f\u5217\u4e2d\u7684\u5207\u7247\u4efb\u52a1");
    }

    @Event
    public synchronized void jumpPeer(PeerIndexEvent event) {
        if (!event.key.equals(((DTaskWrapper)this.mTaskWrapper).getKey())) {
            return;
        }
        if (this.isBreak()) {
            ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u5df2\u505c\u6b62\uff0c\u53d1\u9001\u8df3\u8f6c\u4e8b\u4ef6\u5931\u8d25");
            return;
        }
        if (this.jumpThread == null) {
            this.mJumpThreadPool = Executors.newSingleThreadExecutor();
            this.startJumpThread();
        }
        this.mJumpQueue.offer(event);
        this.mJumpThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    M3U8VodLoader.this.notifyJumpQueue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void notifyJumpQueue() {
        try {
            this.EVENT_LOCK.lock();
            this.mEventQueueCondition.signalAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.EVENT_LOCK.unlock();
        }
    }

    synchronized void resumeTask() {
        if (this.isBreak()) {
            ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u5df2\u505c\u6b62\uff0c\u6062\u590d\u4efb\u52a1\u5931\u8d25");
            return;
        }
        if (this.mJumpQueue.size() > 0) {
            ALog.d((String)this.TAG, (String)"\u6709\u65b0\u5b9a\u4f4d\uff0c\u53d6\u6d88\u4e0a\u4e00\u6b21\u64cd\u4f5c");
            this.notifyJumpQueue();
            return;
        }
        ALog.d((String)this.TAG, (String)"\u6062\u590d\u5207\u7247\u4efb\u52a1");
        this.mBeforePeer.clear();
        this.mAfterPeer.clear();
        this.mFlagQueue.clear();
        this.afterPeerIndex.set(0);
        this.beforePeerIndex.set(0);
        this.mCompleteNum.set(0);
        for (ThreadRecord tr : this.mRecord.threadRecords) {
            if (tr.isComplete) {
                this.mCompleteNum.getAndIncrement();
                continue;
            }
            if (tr.threadId < this.mCurrentEvent.peerIndex) {
                this.mBeforePeer.put(tr.threadId, (Object)tr);
                continue;
            }
            this.mAfterPeer.put(tr.threadId, (Object)tr);
        }
        ALog.i((String)this.TAG, (String)String.format("beforeSize = %s, afterSize = %s, mCompleteNum = %s", this.mBeforePeer.size(), this.mAfterPeer.size(), this.mCompleteNum));
        ALog.i((String)this.TAG, (String)String.format("\u5b8c\u6210\u5904\u7406\u6570\u636e\u7684\u64cd\u4f5c\uff0c\u5c06\u4f18\u5148\u4e0b\u8f7d\u3010%s\u3011\u4e4b\u540e\u7684\u5207\u7247", this.mCurrentEvent.peerIndex));
        this.getStateManager().updateStateCount();
        try {
            this.JUMP_LOCK.lock();
            this.mJumpCondition.signalAll();
        }
        finally {
            this.JUMP_LOCK.unlock();
        }
    }

    void notifyWaitLock(boolean isComplete) {
        try {
            TempFlag flag;
            this.LOCK.lock();
            if (isComplete && (flag = this.mFlagQueue.poll(1L, TimeUnit.SECONDS)) != null) {
                ALog.d((String)this.TAG, (String)String.format("\u5207\u7247\u3010%s\u3011\u5b8c\u6210", flag.threadId));
            }
            this.mWaitCondition.signalAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.LOCK.unlock();
        }
    }

    private TempFlag startThreadTask(ThreadTask task, int peerIndex) {
        if (this.isBreak()) {
            ALog.w((String)this.TAG, (String)"\u4efb\u52a1\u5df2\u505c\u6b62\uff0c\u542f\u52a8\u7ebf\u7a0b\u4efb\u52a1\u5931\u8d25");
            return null;
        }
        ThreadTaskManager.getInstance().startThread(((DTaskWrapper)this.mTaskWrapper).getKey(), (IThreadTask)task);
        this.getListener().onPeerStart(((DTaskWrapper)this.mTaskWrapper).getKey(), task.getConfig().tempFile.getPath(), peerIndex);
        TempFlag flag = new TempFlag();
        flag.threadTask = task;
        flag.threadId = peerIndex;
        return flag;
    }

    private ThreadTask createThreadTask(String cacheDir, ThreadRecord record, int index) {
        SubThreadConfig config = new SubThreadConfig();
        config.url = record.tsUrl;
        config.tempFile = new File(BaseM3U8Loader.getTsFilePath(cacheDir, record.threadId));
        config.isBlock = this.mRecord.isBlock;
        config.taskWrapper = this.mTaskWrapper;
        config.record = record;
        config.stateHandler = this.mStateHandler;
        config.peerIndex = index;
        config.threadType = SubThreadConfig.getThreadType((int)8);
        config.updateInterval = SubThreadConfig.getUpdateInterval((int)8);
        config.ignoreFailure = this.mM3U8Option.isIgnoreFailureTs();
        if (!config.tempFile.exists()) {
            FileUtil.createFile((File)config.tempFile);
        }
        ThreadTask threadTask = new ThreadTask(config);
        M3U8ThreadTaskAdapter adapter = new M3U8ThreadTaskAdapter(config);
        threadTask.setAdapter((IThreadTaskAdapter)adapter);
        return threadTask;
    }

    public void addComponent(IRecordHandler recordHandler) {
        this.mRecordHandler = recordHandler;
    }

    public void addComponent(IInfoTask infoTask) {
        this.mInfoTask = infoTask;
        final ArrayList urls = new ArrayList();
        this.mInfoTask.setCallback(new IInfoTask.Callback(){

            public void onSucceed(String key, CompleteInfo info) {
                VodTsDefConverter converter;
                VodTsDefConverter vodTsDefConverter = converter = M3U8VodLoader.this.mM3U8Option.isUseDefConvert() ? new VodTsDefConverter() : M3U8VodLoader.this.mM3U8Option.getVodUrlConverter();
                if (converter != null) {
                    if (TextUtils.isEmpty((CharSequence)M3U8VodLoader.this.mM3U8Option.getBandWidthUrl())) {
                        urls.addAll(converter.convert(M3U8VodLoader.this.getEntity().getUrl(), (List)info.obj));
                    } else {
                        urls.addAll(converter.convert(M3U8VodLoader.this.mM3U8Option.getBandWidthUrl(), (List)info.obj));
                    }
                } else {
                    urls.addAll((Collection)info.obj);
                }
                if (urls.isEmpty()) {
                    M3U8VodLoader.this.fail((AriaException)new AriaM3U8Exception("\u83b7\u53d6\u5730\u5740\u5931\u8d25"), false);
                    return;
                }
                if (!((String)urls.get(0)).startsWith("http")) {
                    M3U8VodLoader.this.fail((AriaException)new AriaM3U8Exception("\u5730\u5740\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528IVodTsUrlConverter\u5904\u7406\u4f60\u7684url\u4fe1\u606f"), false);
                    return;
                }
                M3U8VodLoader.this.mM3U8Option.setUrls(urls);
                if (M3U8VodLoader.this.isStop) {
                    M3U8VodLoader.this.getListener().onStop(M3U8VodLoader.this.getEntity().getCurrentProgress());
                } else if (M3U8VodLoader.this.isCancel) {
                    M3U8VodLoader.this.getListener().onCancel();
                } else {
                    M3U8VodLoader.this.startThreadTask();
                }
            }

            public void onFail(AbsEntity entity, AriaException e, boolean needRetry) {
                M3U8VodLoader.this.fail(e, needRetry);
            }
        });
    }

    protected void fail(AriaException e, boolean needRetry) {
        if (this.isBreak()) {
            return;
        }
        this.getListener().onFail(needRetry, e);
        this.onDestroy();
    }

    public void addComponent(IThreadStateManager threadState) {
        this.mStateManager = threadState;
    }

    @Deprecated
    public void addComponent(IThreadTaskBuilder builder) {
    }

    protected VodStateManager getStateManager() {
        return (VodStateManager)this.mStateManager;
    }

    protected void checkComponent() {
        if (this.mRecordHandler == null) {
            throw new NullPointerException("\u4efb\u52a1\u8bb0\u5f55\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.mInfoTask == null) {
            throw new NullPointerException("\u6587\u4ef6\u4fe1\u606f\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.getStateManager() == null) {
            throw new NullPointerException("\u4efb\u52a1\u72b6\u6001\u7ba1\u7406\u7ec4\u4ef6\u4e3a\u7a7a");
        }
    }

    private static class TempFlag {
        ThreadTask threadTask;
        int threadId;

        private TempFlag() {
        }
    }
}

