/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8.vod;

import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.RecordHandler;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.M3U8Entity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.m3u8.BaseM3U8Loader;
import com.arialyy.aria.m3u8.M3U8TaskOption;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.util.ArrayList;

final class VodRecordHandler
extends RecordHandler {
    private M3U8TaskOption mOption;

    VodRecordHandler(DTaskWrapper wrapper) {
        super((AbsTaskWrapper)wrapper);
    }

    public void setOption(M3U8TaskOption option) {
        this.mOption = option;
    }

    public void handlerTaskRecord(TaskRecord mTaskRecord) {
        M3U8Entity m3U8Entity;
        String cacheDir = this.mOption.getCacheDir();
        long currentProgress = 0L;
        int completeNum = 0;
        File targetFile = new File(mTaskRecord.filePath);
        if (!targetFile.exists()) {
            FileUtil.createFile((File)targetFile);
        }
        boolean reDownload = (m3U8Entity = ((DownloadEntity)this.getEntity()).getM3U8Entity()).getPeerNum() <= 0 || this.mOption.isGenerateIndexFile() && !new File(String.format("%s.index", this.getEntity().getFilePath())).exists();
        for (ThreadRecord record : mTaskRecord.threadRecords) {
            File temp = new File(BaseM3U8Loader.getTsFilePath(cacheDir, record.threadId));
            if (!record.isComplete || reDownload) {
                if (temp.exists()) {
                    FileUtil.deleteFile((File)temp);
                }
                record.startLocation = 0L;
                continue;
            }
            if (!temp.exists()) {
                record.startLocation = 0L;
                record.isComplete = false;
                ALog.w((String)this.TAG, (String)String.format("\u5206\u7247\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u5c06\u91cd\u65b0\u4e0b\u8f7d\u8be5\u5206\u7247", record.threadId));
                continue;
            }
            ++completeNum;
            currentProgress += temp.length();
        }
        this.mOption.setCompleteNum(completeNum);
        this.getEntity().setCurrentProgress(currentProgress);
        mTaskRecord.bandWidth = this.mOption.getBandWidth();
    }

    public ThreadRecord createThreadRecord(TaskRecord record, int threadId, long startL, long endL) {
        ThreadRecord tr = new ThreadRecord();
        tr.taskKey = record.filePath;
        tr.threadId = threadId;
        tr.isComplete = false;
        tr.startLocation = 0L;
        tr.threadType = record.taskType;
        tr.tsUrl = this.mOption.getUrls().get(threadId);
        return tr;
    }

    public TaskRecord createTaskRecord(int threadNum) {
        TaskRecord record = new TaskRecord();
        record.fileName = this.getEntity().getFileName();
        record.filePath = this.getEntity().getFilePath();
        record.threadRecords = new ArrayList();
        record.threadNum = threadNum;
        record.isBlock = true;
        record.taskType = 7;
        record.bandWidth = this.mOption.getBandWidth();
        return record;
    }

    public int initTaskThreadNum() {
        if (this.getWrapper().getRequestType() == 7) {
            return this.mOption.getUrls() == null || this.mOption.getUrls().isEmpty() ? 1 : this.mOption.getUrls().size();
        }
        if (this.getWrapper().getRequestType() == 8) {
            return 1;
        }
        return 0;
    }
}

