/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.m3u8.vod;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.processor.ITsMergeHandler;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.task.ThreadTask;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.exception.AriaM3U8Exception;
import com.arialyy.aria.m3u8.BaseM3U8Loader;
import com.arialyy.aria.m3u8.M3U8Listener;
import com.arialyy.aria.m3u8.M3U8TaskOption;
import com.arialyy.aria.m3u8.vod.M3U8VodLoader;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class VodStateManager
implements IThreadStateManager {
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private M3U8Listener listener;
    private int startThreadNum;
    private AtomicInteger cancelNum = new AtomicInteger(0);
    private AtomicInteger stopNum = new AtomicInteger(0);
    private AtomicInteger failNum = new AtomicInteger(0);
    private long progress;
    private TaskRecord taskRecord;
    private Looper looper;
    private DTaskWrapper wrapper;
    private M3U8TaskOption m3U8Option;
    private M3U8VodLoader loader;
    private Handler.Callback callback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            int peerIndex = msg.getData().getInt("DATA_M3U8_PEER_INDEX");
            switch (msg.what) {
                case 1: {
                    VodStateManager.this.stopNum.getAndIncrement();
                    VodStateManager.this.removeSignThread((ThreadTask)msg.obj);
                    if (VodStateManager.this.loader.isJump() && (VodStateManager.this.stopNum.get() == VodStateManager.this.loader.getCurrentFlagSize() || VodStateManager.this.loader.getCurrentFlagSize() == 0) && !VodStateManager.this.loader.isBreak()) {
                        VodStateManager.this.loader.resumeTask();
                        return true;
                    }
                    if (!VodStateManager.this.loader.isBreak()) break;
                    ALog.d((String)VodStateManager.this.TAG, (String)String.format("vod\u4efb\u52a1\u3010%s\u3011\u505c\u6b62", VodStateManager.this.loader.getTempFile().getName()));
                    VodStateManager.this.quitLooper();
                    break;
                }
                case 3: {
                    VodStateManager.this.cancelNum.getAndIncrement();
                    VodStateManager.this.removeSignThread((ThreadTask)msg.obj);
                    if (!VodStateManager.this.loader.isBreak()) break;
                    ALog.d((String)VodStateManager.this.TAG, (String)String.format("vod\u4efb\u52a1\u3010%s\u3011\u53d6\u6d88", VodStateManager.this.loader.getTempFile().getName()));
                    VodStateManager.this.quitLooper();
                    break;
                }
                case 2: {
                    VodStateManager.this.failNum.getAndIncrement();
                    for (ThreadRecord tr : ((VodStateManager)VodStateManager.this).taskRecord.threadRecords) {
                        if (tr.threadId != peerIndex) continue;
                        VodStateManager.this.loader.getBeforePeer().put(peerIndex, (Object)tr);
                        break;
                    }
                    VodStateManager.this.getListener().onPeerFail(VodStateManager.this.wrapper.getKey(), msg.getData().getString("DATA_M3U8_PEER_PATH"), peerIndex);
                    if (!VodStateManager.this.isFail()) break;
                    ALog.d((String)VodStateManager.this.TAG, (String)String.format("vod\u4efb\u52a1\u3010%s\u3011\u5931\u8d25", VodStateManager.this.loader.getTempFile().getName()));
                    Bundle b = msg.getData();
                    VodStateManager.this.listener.onFail(b.getBoolean("DATA_RETRY", true), (AriaException)b.getSerializable("DATA_ERROR_INFO"));
                    VodStateManager.this.quitLooper();
                    break;
                }
                case 4: {
                    if (VodStateManager.this.loader.isBreak()) {
                        VodStateManager.this.quitLooper();
                    }
                    VodStateManager.this.loader.setCompleteNum(VodStateManager.this.loader.getCompleteNum() + 1);
                    if (VodStateManager.this.loader.isJump()) {
                        VodStateManager.this.loader.setCurrentFlagSize(VodStateManager.this.loader.getCurrentFlagSize() - 1);
                        if (VodStateManager.this.loader.getCurrentFlagSize() < 0) {
                            VodStateManager.this.loader.setCurrentFlagSize(0);
                        }
                    }
                    VodStateManager.this.removeSignThread((ThreadTask)msg.obj);
                    VodStateManager.this.getListener().onPeerComplete(VodStateManager.this.wrapper.getKey(), msg.getData().getString("DATA_M3U8_PEER_PATH"), peerIndex);
                    VodStateManager.this.handlerPercent();
                    if (!VodStateManager.this.loader.isJump()) {
                        VodStateManager.this.loader.notifyWaitLock(true);
                    }
                    if (!VodStateManager.this.isComplete()) break;
                    VodStateManager.this.handleTaskComplete();
                    break;
                }
                case 5: {
                    Bundle b = msg.getData();
                    if (b == null) break;
                    long len = b.getLong("DATA_ADD_LEN", 0L);
                    VodStateManager.this.progress = VodStateManager.this.progress + len;
                }
            }
            return true;
        }
    };

    VodStateManager(DTaskWrapper wrapper, M3U8Listener listener) {
        this.wrapper = wrapper;
        this.listener = listener;
        this.m3U8Option = (M3U8TaskOption)wrapper.getM3u8Option();
        this.progress = ((DownloadEntity)wrapper.getEntity()).getCurrentProgress();
    }

    void handleTaskComplete() {
        ALog.d((String)this.TAG, (String)String.format("startThreadNum = %s, stopNum = %s, cancelNum = %s, failNum = %s, completeNum = %s, flagQueueSize = %s", this.startThreadNum, this.stopNum, this.cancelNum, this.failNum, this.loader.getCompleteNum(), this.loader.getCurrentFlagSize()));
        ALog.d((String)this.TAG, (String)String.format("vod\u4efb\u52a1\u3010%s\u3011\u5b8c\u6210", this.loader.getTempFile().getName()));
        if (this.m3U8Option.isGenerateIndexFile()) {
            if (this.loader.generateIndexFile(false)) {
                this.listener.onComplete();
            } else {
                this.listener.onFail(false, (AriaException)new AriaM3U8Exception("\u521b\u5efa\u7d22\u5f15\u6587\u4ef6\u5931\u8d25"));
            }
        } else if (this.m3U8Option.isMergeFile()) {
            if (this.mergeFile()) {
                this.listener.onComplete();
            } else {
                this.listener.onFail(false, null);
            }
        } else {
            this.listener.onComplete();
        }
        this.quitLooper();
    }

    void updateStateCount() {
        this.cancelNum.set(0);
        this.stopNum.set(0);
        this.failNum.set(0);
    }

    public void setLooper(TaskRecord taskRecord, Looper looper) {
        this.looper = looper;
        this.taskRecord = taskRecord;
        for (ThreadRecord record : taskRecord.threadRecords) {
            if (record.isComplete) continue;
            ++this.startThreadNum;
        }
    }

    public Handler.Callback getHandlerCallback() {
        return this.callback;
    }

    private DownloadEntity getEntity() {
        return (DownloadEntity)this.wrapper.getEntity();
    }

    private M3U8Listener getListener() {
        return this.listener;
    }

    void setVodLoader(M3U8VodLoader loader) {
        this.loader = loader;
    }

    private void quitLooper() {
        ALog.d((String)this.TAG, (String)"quitLooper");
        this.looper.quit();
    }

    private void removeSignThread(ThreadTask threadTask) {
        this.loader.getTaskList().remove(threadTask);
        ThreadTaskManager.getInstance().removeSingleTaskThread(this.wrapper.getKey(), (IThreadTask)threadTask);
    }

    private void handlerPercent() {
        int completeNum = this.m3U8Option.getCompleteNum();
        this.m3U8Option.setCompleteNum(++completeNum);
        int percent = completeNum * 100 / this.taskRecord.threadRecords.size();
        this.getEntity().setPercent(percent);
        this.getEntity().update();
    }

    public boolean isFail() {
        this.printInfo("isFail");
        return this.failNum.get() != 0 && this.failNum.get() == this.loader.getCurrentFlagSize() && !this.loader.isJump();
    }

    public boolean isComplete() {
        if (this.m3U8Option.isIgnoreFailureTs()) {
            return this.loader.getCompleteNum() + this.failNum.get() >= this.taskRecord.threadRecords.size() && !this.loader.isJump();
        }
        return this.loader.getCompleteNum() == this.taskRecord.threadRecords.size() && !this.loader.isJump();
    }

    public long getCurrentProgress() {
        return this.progress;
    }

    public void updateCurrentProgress(long currentProgress) {
        this.progress = currentProgress;
    }

    private void printInfo(String tag) {
    }

    private boolean mergeFile() {
        boolean isSuccess;
        ITsMergeHandler mergeHandler = this.m3U8Option.getMergeHandler();
        String cacheDir = this.loader.getCacheDir();
        ArrayList<String> partPath = new ArrayList<String>();
        for (ThreadRecord tr : this.taskRecord.threadRecords) {
            partPath.add(BaseM3U8Loader.getTsFilePath(cacheDir, tr.threadId));
        }
        if (mergeHandler != null) {
            isSuccess = mergeHandler.merge(this.getEntity().getM3U8Entity(), partPath);
            if (mergeHandler.getClass().isAnonymousClass()) {
                this.m3U8Option.setMergeHandler(null);
            }
        } else {
            isSuccess = FileUtil.mergeFile((String)this.taskRecord.filePath, partPath);
        }
        if (isSuccess) {
            File[] files;
            for (File f : files = new File(cacheDir).listFiles()) {
                if (!f.exists()) continue;
                f.delete();
            }
            File cDir = new File(cacheDir);
            if (cDir.exists()) {
                cDir.delete();
            }
            return true;
        }
        ALog.e((String)this.TAG, (String)"\u5408\u5e76\u5931\u8d25");
        return false;
    }

    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent((IThreadStateManager)this);
    }
}

