/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.log;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import me.legrange.log.Level;
import me.legrange.log.Log;
import me.legrange.log.Logger;
import me.legrange.log.PackageLogger;
import me.legrange.log.logger.ConsoleLogger;

final class Router
extends SecurityManager {
    private static final Router INSTANCE = new Router();
    private PackageLogger DEFAULT = new PackageLogger("", new ConsoleLogger(), Level.INFO);
    private final Map<String, PackageLogger> packageLoggers = new HashMap<String, PackageLogger>();

    static Router getInstance() {
        return INSTANCE;
    }

    PackageLogger route() {
        String pack = this.calledFromPackage();
        PackageLogger logger = this.packageLoggers.get(pack);
        if (logger == null) {
            logger = this.determineLoggerFor(pack);
            this.packageLoggers.put(pack, logger);
        }
        return logger;
    }

    synchronized void setDefaultLogger(Logger def) {
        LinkedList toRemove = new LinkedList();
        this.packageLoggers.entrySet().stream().filter(ent -> ent.getValue() == this.DEFAULT).forEachOrdered(ent -> toRemove.add((String)ent.getKey()));
        toRemove.forEach(this.packageLoggers::remove);
        this.DEFAULT = new PackageLogger(this.calledFromPackage(), def, Level.INFO);
    }

    void setDefaultLevel(Level level) {
        this.DEFAULT.setLevel(level);
    }

    synchronized void setLogger(Logger logger) {
        this.setLogger(this.calledFromPackage(), logger);
    }

    synchronized void setLogger(String name, Logger logger) {
        PackageLogger forName = this.determineLoggerFor(name);
        this.setLogger(name, new PackageLogger(name, logger, forName.getLevel()));
    }

    void setLevel(Level level) {
        this.setLevel(this.calledFromPackage(), level);
    }

    void setLevel(String name, Level level) {
        PackageLogger forPkg = this.determineLoggerFor(name);
        if (!forPkg.getPack().equals(name)) {
            this.setLogger(name, new PackageLogger(name, forPkg.getLogger(), level));
        } else {
            forPkg.setLevel(level);
        }
    }

    private void setLogger(String pkg, PackageLogger pkgLogger) {
        this.packageLoggers.put(pkg, pkgLogger);
    }

    private Router() {
    }

    private PackageLogger determineLoggerFor(String find) {
        PackageLogger logger = this.packageLoggers.get(find);
        if (logger == null) {
            if (find.indexOf(46) > 0) {
                return this.determineLoggerFor(find.substring(0, find.lastIndexOf(46)));
            }
            return this.DEFAULT;
        }
        return logger;
    }

    private String calledFromPackage() {
        Class<?>[] contex = this.getClassContext();
        String name = "";
        for (int idx = 0; idx < contex.length; ++idx) {
            Package pkg = contex[idx].getPackage();
            if (pkg != null) {
                name = pkg.getName();
                if (name.equals(Log.class.getPackage().getName())) continue;
                return name;
            }
            return "";
        }
        return name;
    }
}

