/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.mikrotik.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.SocketFactory;
import me.legrange.mikrotik.ApiConnection;
import me.legrange.mikrotik.ApiConnectionException;
import me.legrange.mikrotik.MikrotikApiException;
import me.legrange.mikrotik.ResultListener;
import me.legrange.mikrotik.impl.ApiCommandException;
import me.legrange.mikrotik.impl.ApiDataException;
import me.legrange.mikrotik.impl.Command;
import me.legrange.mikrotik.impl.Done;
import me.legrange.mikrotik.impl.Error;
import me.legrange.mikrotik.impl.Parser;
import me.legrange.mikrotik.impl.Response;
import me.legrange.mikrotik.impl.Result;
import me.legrange.mikrotik.impl.Util;

public final class ApiConnectionImpl
extends ApiConnection {
    private Socket sock = null;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private boolean connected = false;
    private Reader reader;
    private Processor processor;
    private final Map<String, ResultListener> listeners = new ConcurrentHashMap<String, ResultListener>();
    private Integer _tag = 0;
    private int timeout = 60000;

    public static ApiConnection connect(SocketFactory fact, String host, int port, int timeOut) throws ApiConnectionException {
        ApiConnectionImpl con = new ApiConnectionImpl();
        con.open(host, port, fact, timeOut);
        return con;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void login(String username, String password) throws MikrotikApiException {
        Map<String, String> res;
        if (username.trim().isEmpty()) {
            throw new ApiConnectionException("API username cannot be empty");
        }
        Command cmd = new Command("/login");
        cmd.addParameter("name", username);
        cmd.addParameter("password", password);
        List<Map<String, String>> list = this.execute(cmd, this.timeout);
        if (!list.isEmpty() && (res = list.get(0)).containsKey("ret")) {
            String hash = res.get("ret");
            String chal = Util.hexStrToStr("00") + new String(password.toCharArray()) + Util.hexStrToStr(hash);
            chal = Util.hashMD5(chal);
            this.execute("/login name=" + username + " response=00" + chal);
        }
    }

    @Override
    public List<Map<String, String>> execute(String cmd) throws MikrotikApiException {
        return this.execute(Parser.parse(cmd), this.timeout);
    }

    @Override
    public String execute(String cmd, ResultListener lis) throws MikrotikApiException {
        return this.execute(Parser.parse(cmd), lis);
    }

    @Override
    public void cancel(String tag) throws MikrotikApiException {
        this.execute(String.format("/cancel tag=%s", tag));
    }

    @Override
    public void setTimeout(int timeout) throws MikrotikApiException {
        if (timeout <= 0) {
            throw new MikrotikApiException(String.format("Invalid timeout value '%d'; must be postive", timeout));
        }
        this.timeout = timeout;
    }

    @Override
    public void close() throws ApiConnectionException {
        if (!this.connected) {
            throw new ApiConnectionException("Not/no longer connected to remote Mikrotik");
        }
        this.connected = false;
        this.processor.interrupt();
        this.reader.interrupt();
        try {
            this.in.close();
            this.out.close();
            this.sock.close();
        }
        catch (IOException ex) {
            throw new ApiConnectionException(String.format("Error closing socket: %s", ex.getMessage()), ex);
        }
    }

    private List<Map<String, String>> execute(Command cmd, int timeout) throws MikrotikApiException {
        SyncListener l = new SyncListener();
        this.execute(cmd, (ResultListener)l);
        return l.getResults(timeout);
    }

    private String execute(Command cmd, ResultListener lis) throws MikrotikApiException {
        String tag = this.nextTag();
        cmd.setTag(tag);
        this.listeners.put(tag, lis);
        try {
            Util.write(cmd, this.out);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ApiDataException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new ApiConnectionException(ex.getMessage(), ex);
        }
        return tag;
    }

    private ApiConnectionImpl() {
    }

    private void open(String host, int port, SocketFactory fact, int conTimeout) throws ApiConnectionException {
        try {
            InetAddress ia = InetAddress.getByName(host.trim());
            this.sock = fact.createSocket();
            this.sock.connect(new InetSocketAddress(ia, port), conTimeout);
            this.in = new DataInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
            this.reader = new Reader();
            this.reader.setDaemon(true);
            this.reader.start();
            this.processor = new Processor();
            this.processor.setDaemon(true);
            this.processor.start();
        }
        catch (UnknownHostException ex) {
            this.connected = false;
            throw new ApiConnectionException(String.format("Unknown host '%s'", host), ex);
        }
        catch (IOException ex) {
            this.connected = false;
            throw new ApiConnectionException(String.format("Error connecting to %s:%d : %s", host, port, ex.getMessage()), ex);
        }
    }

    private synchronized String nextTag() {
        Integer n = this._tag;
        Integer n2 = this._tag = Integer.valueOf(this._tag + 1);
        return Integer.toHexString(this._tag);
    }

    private static class SyncListener
    implements ResultListener {
        private final List<Map<String, String>> results = new LinkedList<Map<String, String>>();
        private MikrotikApiException err;
        private boolean complete = false;

        private SyncListener() {
        }

        @Override
        public synchronized void error(MikrotikApiException ex) {
            this.err = ex;
            this.notifyAll();
        }

        @Override
        public synchronized void completed() {
            this.complete = true;
            this.notifyAll();
        }

        synchronized void completed(Done done) {
            if (done.getHash() != null) {
                Result res = new Result();
                res.put("ret", done.getHash());
                this.results.add(res);
            }
            this.complete = true;
            this.notifyAll();
        }

        @Override
        public void receive(Map<String, String> result) {
            this.results.add(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Map<String, String>> getResults(int timeout) throws MikrotikApiException {
            try {
                SyncListener syncListener = this;
                synchronized (syncListener) {
                    int waitTime = timeout;
                    while (!this.complete && waitTime > 0) {
                        long start = System.currentTimeMillis();
                        this.wait(waitTime);
                        if ((waitTime -= (int)(System.currentTimeMillis() - start)) > 0 || this.complete) continue;
                        this.err = new ApiConnectionException(String.format("Command timed out after %d ms", timeout));
                    }
                }
            }
            catch (InterruptedException ex) {
                throw new ApiConnectionException(ex.getMessage(), ex);
            }
            if (this.err != null) {
                throw new MikrotikApiException(this.err.getMessage(), this.err);
            }
            return this.results;
        }
    }

    private class Processor
    extends Thread {
        private final List<String> lines;
        private String line;

        private Processor() {
            super("Mikrotik API Result Processor");
            this.lines = new LinkedList<String>();
        }

        @Override
        public void run() {
            while (ApiConnectionImpl.this.connected) {
                ResultListener l;
                Response res;
                try {
                    res = this.unpack();
                }
                catch (ApiCommandException ex) {
                    String tag = ex.getTag();
                    if (tag == null) continue;
                    res = new Error(tag, ex.getMessage(), ex.getCategory());
                }
                catch (MikrotikApiException ex) {
                    continue;
                }
                if ((l = (ResultListener)ApiConnectionImpl.this.listeners.get(res.getTag())) == null) continue;
                if (res instanceof Result) {
                    l.receive((Result)res);
                    continue;
                }
                if (res instanceof Done) {
                    if (l instanceof SyncListener) {
                        ((SyncListener)l).completed((Done)res);
                    } else {
                        l.completed();
                    }
                    ApiConnectionImpl.this.listeners.remove(res.getTag());
                    continue;
                }
                if (!(res instanceof Error)) continue;
                l.error(new ApiCommandException((Error)res));
            }
        }

        private void nextLine() throws ApiConnectionException, ApiDataException {
            if (this.lines.isEmpty()) {
                String block = ApiConnectionImpl.this.reader.take();
                String[] parts = block.split("\n");
                this.lines.addAll(Arrays.asList(parts));
            }
            this.line = this.lines.remove(0);
        }

        private boolean hasNextLine() {
            return !this.lines.isEmpty() || !ApiConnectionImpl.this.reader.isEmpty();
        }

        private String peekLine() throws ApiConnectionException, ApiDataException {
            if (this.lines.isEmpty()) {
                String block = ApiConnectionImpl.this.reader.take();
                String[] parts = block.split("\n");
                this.lines.addAll(Arrays.asList(parts));
            }
            return this.lines.get(0);
        }

        private Response unpack() throws MikrotikApiException {
            if (this.line == null) {
                this.nextLine();
            }
            switch (this.line) {
                case "!re": {
                    return this.unpackRe();
                }
                case "!done": {
                    return this.unpackDone();
                }
                case "!trap": {
                    return this.unpackError();
                }
                case "!halt": {
                    return this.unpackError();
                }
            }
            throw new ApiDataException(String.format("Unexpected line '%s'", this.line));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Result unpackRe() throws ApiDataException, ApiConnectionException {
            this.nextLine();
            int l = 0;
            Result res = new Result();
            while (!this.line.startsWith("!")) {
                String[] parts;
                ++l;
                if (this.line.startsWith("=")) {
                    parts = this.line.split("=", 3);
                    if (parts.length != 3) throw new ApiDataException(String.format("Malformed line '%s'", this.line));
                    if (!parts[2].endsWith("\r")) {
                        res.put(parts[1], this.unpackResult(parts[2]));
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append(parts[2]);
                        while (!this.lines.isEmpty()) {
                            this.nextLine();
                            sb.append(this.line);
                        }
                        res.put(parts[1], sb.toString());
                    }
                } else {
                    if (!this.line.startsWith(".tag=")) throw new ApiDataException(String.format("Unexpected line '%s'", this.line));
                    parts = this.line.split("=", 2);
                    if (parts.length == 2) {
                        res.setTag(parts[1]);
                    }
                }
                if (this.hasNextLine()) {
                    this.nextLine();
                    continue;
                }
                this.line = null;
                return res;
            }
            return res;
        }

        private String unpackResult(String first) throws ApiConnectionException, ApiDataException {
            String peek;
            StringBuilder buf = new StringBuilder(first);
            this.line = null;
            while (this.hasNextLine() && !(peek = this.peekLine()).startsWith("!") && !peek.startsWith("=") && !peek.startsWith(".tag=")) {
                this.nextLine();
                buf.append("\n");
                buf.append(this.line);
            }
            return buf.toString();
        }

        private Done unpackDone() throws MikrotikApiException {
            Done done = new Done(null);
            if (this.hasNextLine()) {
                this.nextLine();
                while (!this.line.startsWith("!")) {
                    String[] parts;
                    if (this.line.startsWith(".tag=")) {
                        parts = this.line.split("=", 2);
                        if (parts.length == 2) {
                            done.setTag(parts[1]);
                        }
                    } else if (this.line.startsWith("=ret")) {
                        parts = this.line.split("=", 3);
                        if (parts.length == 3) {
                            done.setHash(parts[2]);
                        } else {
                            throw new ApiDataException(String.format("Malformed line '%s'", this.line));
                        }
                    }
                    if (this.hasNextLine()) {
                        this.nextLine();
                        continue;
                    }
                    this.line = null;
                    break;
                }
            }
            return done;
        }

        private Error unpackError() throws MikrotikApiException {
            this.nextLine();
            Error err = new Error();
            if (this.hasNextLine()) {
                while (!this.line.startsWith("!")) {
                    if (this.line.startsWith(".tag=")) {
                        String[] parts = this.line.split("=", 2);
                        if (parts.length == 2) {
                            err.setTag(parts[1]);
                        }
                    } else if (this.line.startsWith("=message=")) {
                        err.setMessage(this.line.split("=", 3)[2]);
                    } else if (this.line.startsWith("=category=")) {
                        err.setCategory(Integer.parseInt(this.line.split("=", 3)[2]));
                    }
                    if (this.hasNextLine()) {
                        this.nextLine();
                        continue;
                    }
                    this.line = null;
                    break;
                }
            }
            return err;
        }
    }

    private class Reader
    extends Thread {
        private final LinkedBlockingQueue queue;

        private Reader() {
            super("Mikrotik API Reader");
            this.queue = new LinkedBlockingQueue(40);
        }

        private String take() throws ApiConnectionException, ApiDataException {
            Object val = null;
            try {
                val = this.queue.take();
            }
            catch (InterruptedException ex) {
                throw new ApiConnectionException("Interrupted while reading data from queue.", ex);
            }
            if (val instanceof ApiConnectionException) {
                throw (ApiConnectionException)val;
            }
            if (val instanceof ApiDataException) {
                throw (ApiDataException)val;
            }
            return val;
        }

        private boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void run() {
            while (ApiConnectionImpl.this.connected) {
                try {
                    String s = Util.decode(ApiConnectionImpl.this.in);
                    this.put(s);
                }
                catch (ApiDataException ex) {
                    this.put(ex);
                }
                catch (ApiConnectionException ex) {
                    if (!ApiConnectionImpl.this.connected && ApiConnectionImpl.this.sock.isClosed()) continue;
                    this.put(ex);
                }
            }
        }

        private void put(Object data) {
            try {
                this.queue.put(data);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

