/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.logging;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import me.legrange.log.Level;
import me.legrange.log.Log;
import me.legrange.log.Logger;
import me.legrange.log.logger.ConsoleLogger;
import me.legrange.log.logger.FileLogger;
import me.legrange.log.logger.LoggerException;
import me.legrange.log.logger.NumberedExceptionLogger;
import me.legrange.service.Component;
import me.legrange.service.ComponentException;
import me.legrange.service.Service;
import me.legrange.services.logging.CustomLoggerConfig;
import me.legrange.services.logging.FileLoggerConfig;
import me.legrange.services.logging.LoggingConfig;
import me.legrange.services.logging.NumberedLoggerConfig;

public class LoggingComponent
extends Component<Service<?>, LoggingConfig> {
    private Logger logger;

    public LoggingComponent(Service<?> service) {
        super(service);
    }

    public void start(LoggingConfig config) throws ComponentException {
        try {
            CustomLoggerConfig clc;
            this.logger = null;
            if (config.getFileLogger() != null) {
                this.logger = this.startFileLogger(config.getFileLogger());
            } else if (config.getConsoleLogger() != null) {
                this.logger = this.startConsoleLogger();
            } else {
                throw new ComponentException("No primary logger defined. Check your configuration!");
            }
            NumberedLoggerConfig nelc = config.getNumberedExceptionLogger();
            if (nelc != null) {
                this.logger = this.startNumberedExceptionLogger(this.logger, nelc);
            }
            if ((clc = config.getCustomLogger()) != null) {
                this.logger = this.startCustomLogger(this.logger, clc);
            }
            if (!this.logger.getClass().equals(ConsoleLogger.class)) {
                Log.info((String)"Switching logging to %s with default level %s", (Object[])new Object[]{this.logger.getName(), config.getLevel()});
            }
            Log.setDefaultLogger((Logger)this.logger);
            Log.setDefaultLevel((Level)config.getLevel());
            if (!this.logger.getClass().equals(ConsoleLogger.class)) {
                Log.info((String)"Logging to %s with default level %s", (Object[])new Object[]{this.logger.getName(), config.getLevel()});
            }
            if (!config.getLevels().isEmpty()) {
                Log.info((String)"Setting up log levels for packages/name spaces", (Object[])new Object[0]);
                for (String name : config.getLevels().keySet()) {
                    Log.setLevel((String)name, (Level)config.getLevels().get(name));
                }
            }
        }
        catch (LoggerException ex) {
            throw new ComponentException(String.format("Error setting up logging: %s", ex.getMessage()), (Throwable)ex);
        }
    }

    public String getName() {
        return "logging";
    }

    Logger getLogger() {
        return this.logger;
    }

    private Logger startFileLogger(FileLoggerConfig flc) throws LoggerException {
        return new FileLogger(flc.getFileName());
    }

    private Logger startConsoleLogger() throws LoggerException {
        return new ConsoleLogger();
    }

    private Logger startNumberedExceptionLogger(Logger logger, NumberedLoggerConfig flc) throws LoggerException {
        if (flc.getFileName() != null) {
            return new NumberedExceptionLogger(logger, flc.getFileName());
        }
        return new NumberedExceptionLogger(logger, new PrintWriter(System.err));
    }

    private Logger startCustomLogger(Logger logger, CustomLoggerConfig clc) throws LoggerException {
        try {
            Class<?> type = Class.forName(clc.getClassName());
            if (!Logger.class.isAssignableFrom(type)) {
                throw new LoggerException(String.format("Class %s does not implement a logger", type.getSimpleName()));
            }
            return (Logger)type.getConstructor(Logger.class).newInstance(logger);
        }
        catch (ClassNotFoundException e) {
            throw new LoggerException(String.format("Cannot find class '%s' for custom logger. Check your configuration", clc.getClassName()));
        }
        catch (NoSuchMethodException e) {
            throw new LoggerException(String.format("Logger class '%s' does not have a constructor that accepts a Logger", clc.getClassName()));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new LoggerException(String.format("Logger class '%s' fails on start (%s)", clc.getClassName(), e.getMessage()));
        }
    }
}

