/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.legrange.service.Component;
import me.legrange.service.ComponentException;
import me.legrange.service.Service;
import me.legrange.services.logging.WithLogging;
import me.legrange.services.rabbitmq.RabbitMqConfig;

public final class RabbitMqComponent
extends Component<Service, RabbitMqConfig>
implements WithLogging {
    private Connection rabbitMq;
    private Channel channel;
    private RabbitMqConfig conf;

    public RabbitMqComponent(Service service) {
        super(service);
    }

    public void start(RabbitMqConfig conf) throws ComponentException {
        this.conf = conf;
        if (!conf.isStartOnRequest()) {
            this.startRabbitMq();
        }
    }

    private void startRabbitMq() throws ComponentException {
        boolean connected = false;
        int retries = 0;
        while (!connected) {
            try {
                this.info("Connecting to RabbitMQ server %s", new Object[]{this.conf.getHostname()});
                ConnectionFactory factory = new ConnectionFactory();
                factory.setUsername(this.conf.getUsername());
                factory.setPassword(this.conf.getPassword());
                factory.setVirtualHost(this.conf.getVirtualHost());
                if (this.conf.isSecure()) {
                    try {
                        factory.setUri("amqps://" + this.conf.getHostname());
                    }
                    catch (URISyntaxException | KeyManagementException | NoSuchAlgorithmException e) {
                        this.error("Error configuring amqps URI: %s", new Object[]{e.getMessage()});
                    }
                } else {
                    factory.setHost(this.conf.getHostname());
                }
                factory.setPort(this.conf.getPort());
                factory.setAutomaticRecoveryEnabled(true);
                this.rabbitMq = factory.newConnection();
                this.rabbitMq.addShutdownListener(signal -> this.warning("RabbitMQ connection to %s shut down. Reason: %s", new Object[]{this.conf.getHostname(), signal.getMessage()}));
                this.channel = this.rabbitMq.createChannel();
                connected = true;
                this.info("Connected to RabbitMQ server %s", new Object[]{this.conf.getHostname()});
            }
            catch (IOException ex) {
                this.error(ex, "Error connecting to RabbitMQ server %s: %s", new Object[]{this.conf.getHostname(), ex.getMessage()});
            }
            catch (TimeoutException ex) {
                this.error(ex, "Timeout connecting to RabbitMQ server %s: %s", new Object[]{this.conf.getHostname(), ex.getMessage()});
            }
            if (connected) continue;
            this.warning("Could not connect to RabbitMQ server %s. Retrying in %d seconds", new Object[]{this.conf.getHostname(), this.conf.getRetryTime()});
            try {
                ++retries;
                TimeUnit.SECONDS.sleep(this.conf.getRetryTime());
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public Connection getConnection() throws ComponentException {
        if (this.rabbitMq == null) {
            this.startRabbitMq();
        }
        return this.rabbitMq;
    }

    public Channel getChannel() throws ComponentException {
        if (this.rabbitMq == null) {
            this.startRabbitMq();
        }
        return this.channel;
    }

    public String getName() {
        return "rabbitMq";
    }
}

