/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.rabbitmq;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;

public class RabbitMqConfig {
    @NotBlank(message="The RabbitMQ username must be specified")
    private @NotBlank(message="The RabbitMQ username must be specified") String username;
    @NotBlank(message="The RabbitMQ password must be specified")
    private @NotBlank(message="The RabbitMQ password must be specified") String password;
    @NotBlank(message="The RabbitMQ server host name must be specified")
    private @NotBlank(message="The RabbitMQ server host name must be specified") String hostname;
    private boolean secure = false;
    @NotBlank(message="The RabbitMQ server virtual host name must be specified (default '/')")
    private @NotBlank(message="The RabbitMQ server virtual host name must be specified (default '/')") String virtualHost = "/";
    @Min(value=1L, message="The RabbitMQ server must have a port in the range 1 to 65535")
    @Max(value=65535L, message="The RabbitMQ server must have a port in the range 1 to 65535")
    private @Min(value=1L, message="The RabbitMQ server must have a port in the range 1 to 65535") @Max(value=65535L, message="The RabbitMQ server must have a port in the range 1 to 65535") int port = 5672;
    @Min(value=1L, message="The RabbitMQ retry time must be in the range of 1 to 900 seconds")
    @Max(value=900L, message="The RabbitMQ retry time must be in the range of 1 to 900 seconds")
    private @Min(value=1L, message="The RabbitMQ retry time must be in the range of 1 to 900 seconds") @Max(value=900L, message="The RabbitMQ retry time must be in the range of 1 to 900 seconds") int retryTime = 10;
    private boolean startOnRequest = false;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(int retryTime) {
        this.retryTime = retryTime;
    }

    public boolean isStartOnRequest() {
        return this.startOnRequest;
    }

    public void setStartOnRequest(boolean startOnRequest) {
        this.startOnRequest = startOnRequest;
    }
}

