/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.service;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import me.legrange.config.ConfigurationException;
import me.legrange.config.YamlLoader;
import me.legrange.log.Log;
import me.legrange.service.Component;
import me.legrange.service.ComponentException;
import me.legrange.service.ComponentNotFoundException;
import me.legrange.service.RuntimeEnvironment;
import me.legrange.service.ServiceException;
import me.legrange.service.WithComponent;
import sun.misc.Signal;

public abstract class Service<Conf> {
    private Conf conf;
    private final Map<Class<? extends Component>, Component> components = new HashMap<Class<? extends Component>, Component>();
    private final ExecutorService threadPool = new ForkJoinPool(32);
    private boolean running;

    public static void main(String ... args) {
        try {
            InputStream config = null;
            block3 : switch (args.length) {
                case 1: {
                    config = new FileInputStream(args[0]);
                    break;
                }
                case 2: {
                    switch (args[0]) {
                        case "-file": {
                            config = new FileInputStream(args[1]);
                            break block3;
                        }
                        case "-resource": {
                            config = Service.class.getClassLoader().getResourceAsStream(args[1]);
                            break block3;
                        }
                    }
                }
            }
            if (config == null) {
                Service.failedStartup("Usage: Server [-file|-resource] <config file> ");
            }
            Class<Service> serviceClass = Service.determineServiceClass();
            Service service = serviceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            try {
                Object conf = YamlLoader.readConfiguration((InputStream)config, service.getConfigClass());
                service.start(conf);
            }
            catch (ConfigurationException | ServiceException ex) {
                ex.printStackTrace();
                Service.failedStartup(String.format("Error configuring server: %s", ex.getMessage()));
            }
            while (service.isRunning()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            service.stop();
            System.exit(0);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | ServiceException ex) {
            Log.error((Throwable)ex, (String)"Fatal error: %s", (Object[])new Object[]{ex.getMessage()});
            System.exit(1);
        }
        catch (FileNotFoundException ex) {
            Log.error((Throwable)ex, (String)"Fatal error: %s", (Object[])new Object[]{ex.getMessage()});
        }
    }

    public final void start(Conf config) throws ServiceException {
        this.conf = config;
        this.startComponents();
        this.setupShutdownSignals();
        Log.info((String)"Platform is %s on %s %s", (Object[])new Object[]{RuntimeEnvironment.getOsType(), RuntimeEnvironment.getArch(), RuntimeEnvironment.isInContainer() ? "running in a container" : ""});
        this.start();
        this.running = true;
    }

    public final void stop() throws ServiceException {
        this.running = false;
        this.onStop();
        this.stopComponents();
    }

    public final <C extends Component> C getComponent(Class<C> clazz) throws ComponentNotFoundException {
        if (this.components.containsKey(clazz)) {
            return (C)((Component)clazz.cast(this.components.get(clazz)));
        }
        throw new ComponentNotFoundException(String.format("No component registered of type '%s'. BUG!", clazz.getSimpleName()));
    }

    private void startComponents() throws ServiceException {
        for (Class<Component> clazz : this.getRequiredComponents()) {
            if (this.components.containsKey(clazz)) continue;
            this.startComponent(clazz);
        }
    }

    private void stopComponents() throws ServiceException {
        for (Class<Component> clazz : this.getRequiredComponents()) {
            if (!this.components.containsKey(clazz)) continue;
            try {
                this.stopComponent(clazz);
            }
            catch (ComponentException ex) {
                Log.error((Throwable)ex, (String)"Error stopping component %s (%s)", (Object[])new Object[]{clazz.getSimpleName(), ex.getMessage()});
            }
        }
    }

    private <C extends Component> C startComponent(Class<C> clazz) throws ServiceException {
        try {
            Constructor<C> cons = clazz.getConstructor(Service.class);
            Component comp = (Component)cons.newInstance(this);
            if (comp.requiresConfig()) {
                Object compConf = this.getConfigFor(comp);
                comp.start(compConf);
            } else {
                comp.start(null);
            }
            this.components.put(clazz, comp);
            return (C)comp;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new ServiceException(String.format("Error creating new component of type '%s': %s", clazz.getSimpleName(), ex.getMessage()), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ServiceException(String.format("Could not find constructor with Service as parameter on component of type '%s': %s", clazz.getSimpleName(), ex.getMessage()), ex);
        }
    }

    private <C extends Component> void stopComponent(Class<C> clazz) throws ServiceException {
        Component comp = this.components.get(clazz);
        comp.stop();
    }

    private Class<Conf> getConfigClass() throws ServiceException {
        Object name = this.getClass().getName();
        int idx = ((String)name).lastIndexOf("Service");
        if (idx > 0) {
            name = ((String)name).substring(0, idx);
            name = (String)name + "Config";
        } else if (!((String)name).endsWith("Config")) {
            name = (String)name + "Config";
        }
        try {
            return Class.forName((String)name);
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceException(String.format("Could not find config class '%s' for service class '%s'. BUG!", name, this.getClass().getName()), ex);
        }
    }

    private List<Class<? extends Component>> getRequiredComponents() throws ServiceException {
        return this.getRequiredComponents(this.getClass());
    }

    private List<Class<? extends Component>> getRequiredComponents(Class<?> clazz) throws ServiceException {
        LinkedList<Class<? extends Component>> res = new LinkedList<Class<? extends Component>>();
        Set<Class<WithComponent>> interfaces = this.getWithInterfaces(clazz);
        for (Class<WithComponent> iface : interfaces) {
            String name = iface.getName().replace(".With", ".").concat("Component");
            try {
                Class<?> compClass = Class.forName(name);
                if (Component.class.isAssignableFrom(compClass)) {
                    res.addAll(0, this.getRequiredComponents(compClass));
                    if (res.contains(compClass)) continue;
                    res.add(compClass);
                    continue;
                }
                throw new ServiceException(String.format("Class '%s' associated with interface '%s' does not extend '%s'", name, iface.getName(), Component.class.getName()));
            }
            catch (ClassNotFoundException ex) {
                throw new ServiceException(String.format("Cannot find component class '%s' associated with interface '%s'", name, iface.getName()), ex);
            }
        }
        return res;
    }

    public final <C extends Component> C requireComponent(Class<C> clazz) throws ServiceException {
        if (this.components.containsKey(clazz)) {
            return (C)this.components.get(clazz);
        }
        return this.startComponent(clazz);
    }

    private Set<Class<? extends WithComponent>> getWithInterfaces(Class<?> type) {
        HashSet<Class<? extends WithComponent>> res = new HashSet<Class<? extends WithComponent>>();
        for (Class<?> iface : type.getInterfaces()) {
            if (!WithComponent.class.isAssignableFrom(iface)) continue;
            res.add(iface);
        }
        if (Service.class.isAssignableFrom(type.getSuperclass())) {
            res.addAll(this.getWithInterfaces(type.getSuperclass()));
        } else if (Component.class.isAssignableFrom(type.getSuperclass())) {
            res.addAll(this.getWithInterfaces(type.getSuperclass()));
        }
        return res;
    }

    public final boolean isRunning() {
        return this.running;
    }

    protected abstract void start() throws ServiceException;

    protected void onStop() throws ServiceException {
    }

    protected Conf getConfig() {
        return this.conf;
    }

    public void submit(Runnable task) {
        this.threadPool.submit(() -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                Log.critical((Throwable)ex, (String)"Uncaught exception in task '%s': %s", (Object[])new Object[]{task.getClass().getSimpleName(), ex.getMessage()});
            }
        });
    }

    public final void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void configure(InputStream config) throws ServiceException {
        try {
            this.conf = YamlLoader.readConfiguration((InputStream)config, this.getConfigClass());
        }
        catch (ConfigurationException ex) {
            throw new ServiceException(ex.getMessage(), ex);
        }
    }

    private static void say(String fmt, Object ... args) {
        System.out.printf(fmt, args);
        if (!fmt.endsWith("\n")) {
            System.out.println();
        }
    }

    private Object getConfigFor(Component com) throws ServiceException {
        String name = com.getName();
        String getName = "get" + name;
        for (Method meth : this.conf.getClass().getMethods()) {
            if (!meth.getName().equalsIgnoreCase(getName)) continue;
            try {
                return meth.invoke(this.conf, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new ServiceException(String.format("Cannot find configuration for component '%s' of type '%s' in config object of type '%s'. BUG!", com.getName(), com.getClass().getSimpleName(), this.conf.getClass().getSimpleName()), ex);
            }
        }
        throw new ServiceException(String.format("Cannot find configuration for component '%s' of type '%s' in config object of type '%s'", com.getName(), com.getClass().getSimpleName(), this.conf.getClass().getSimpleName()));
    }

    private static Class<? extends Service> determineServiceClass() throws ServiceException {
        Class[] classContext = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        Class clazz = null;
        for (int idx = 0; idx < classContext.length; ++idx) {
            Class next = classContext[idx];
            if (!Service.class.isAssignableFrom(next)) continue;
            clazz = next;
        }
        if (clazz == null) {
            throw new ServiceException("Could not find the service class to instantiate. Does your application extend Service?");
        }
        if (clazz == Service.class) {
            throw new ServiceException("Could not find the service class to instantiate. Did you implement the main method in your class?");
        }
        return clazz;
    }

    private void setupShutdownSignals() {
        String[] signals;
        String[] stringArray;
        if (RuntimeEnvironment.getOsType() == RuntimeEnvironment.Type.WINDOWS) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "TERM";
            stringArray = stringArray2;
            stringArray2[1] = "INT";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "TERM";
            stringArray3[1] = "INT";
            stringArray = stringArray3;
            stringArray3[2] = "HUP";
        }
        for (String name : signals = stringArray) {
            try {
                Signal.handle(new Signal(name), sig -> {
                    Log.warning((String)"%s signal (%d) received; shutting down", (Object[])new Object[]{sig.getName(), sig.getNumber()});
                    this.running = false;
                });
            }
            catch (IllegalArgumentException ex) {
                Log.warning((String)"Cannot setup signal (%s)", (Object[])new Object[]{ex.getMessage()});
            }
        }
    }

    private static void failedStartup(String reason) {
        Service.say(reason, new Object[0]);
        System.exit(1);
    }
}

