/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.service;

import me.legrange.service.ComponentException;
import me.legrange.service.ComponentNotFoundException;
import me.legrange.service.Service;
import me.legrange.service.ServiceException;

public abstract class Component<S extends Service, C> {
    private final S service;

    protected Component(S service) {
        this.service = service;
    }

    public abstract void start(C var1) throws ComponentException;

    public void stop() throws ComponentException {
    }

    public abstract String getName();

    public boolean requiresConfig() {
        return true;
    }

    protected final S service() {
        return this.service;
    }

    public final <C extends Component> C getComponent(Class<C> clazz) throws ComponentNotFoundException {
        return ((Service)this.service).getComponent(clazz);
    }

    protected final <C extends Component> C requireComponent(Class<C> clazz) throws ServiceException {
        return ((Service)this.service).requireComponent(clazz);
    }
}

