/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.service;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Stream;
import me.legrange.service.EnvironmentDetectionException;

public final class RuntimeEnvironment {
    private static final String OS_NAME = "os.name";
    private static final String OS_ARCH = "os.arch";
    private static final String TMP_DIR = "java.io.tmpdir";
    private static Type type;

    public static boolean isInContainer() {
        boolean bl;
        block8: {
            Stream<String> in = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));
            try {
                bl = in.anyMatch(line -> line.contains("/docker"));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    public static String getArch() {
        String arch;
        switch (arch = System.getProperty(OS_ARCH)) {
            case "amd64": {
                return "x86_64";
            }
            case "arm": {
                return "armv7l";
            }
        }
        return arch;
    }

    public static int getCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static boolean isIpv6Supported() throws EnvironmentDetectionException {
        return RuntimeEnvironment.haveAddressesOfType(Inet6Address.class);
    }

    public static boolean isIpv4Supported() throws EnvironmentDetectionException {
        return RuntimeEnvironment.haveAddressesOfType(Inet4Address.class);
    }

    public static String getApplicationJarName() throws EnvironmentDetectionException {
        try {
            URI uri = RuntimeEnvironment.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            if (uri == null) {
                throw new EnvironmentDetectionException("Cannot determining application JAR path - code source location is null");
            }
            return new File(uri).getPath();
        }
        catch (URISyntaxException e) {
            throw new EnvironmentDetectionException(String.format("Error determining application JAR path (%s)", e.getMessage()), e);
        }
    }

    private static boolean haveAddressesOfType(Class<? extends InetAddress> type) throws EnvironmentDetectionException {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface iface = interfaces.nextElement();
                boolean haveFam = iface.getInterfaceAddresses().stream().filter(address -> type.isAssignableFrom(address.getAddress().getClass())).findFirst().isPresent();
                if (!haveFam) continue;
                return true;
            }
        }
        catch (SocketException e) {
            throw new EnvironmentDetectionException(String.format("Error checking for IPv6 (%s)", e.getMessage()), e);
        }
        return false;
    }

    public static String getTempDir() {
        String temp = System.getProperty(TMP_DIR);
        if (temp == null || temp.isEmpty()) {
            throw new UnsupportedOperationException(String.format("Temporary directory is not specified", new Object[0]));
        }
        return temp;
    }

    public static String getComputerName() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        return String.format("Unknown (%s/%s)", new Object[]{RuntimeEnvironment.getArch(), RuntimeEnvironment.getOsType()});
    }

    public static Type getOsType() {
        if (type == null) {
            String osName = System.getProperty(OS_NAME).toLowerCase();
            if (osName.indexOf("win") >= 0) {
                type = Type.WINDOWS;
            } else if (osName.indexOf("mac") >= 0) {
                type = Type.MACOS;
            } else if (osName.indexOf("inux") >= 0) {
                type = Type.LINUX;
            } else {
                throw new UnsupportedOperationException(String.format("Unknown OS (%s)", osName));
            }
        }
        return type;
    }

    private RuntimeEnvironment() {
    }

    public static enum Type {
        WINDOWS("Windows"),
        LINUX("Linux"),
        MACOS("MacOS");

        private final String description;

        private Type(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

