/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.config;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.legrange.config.ConfigurationException;
import me.legrange.config.ValidationException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public final class YamlLoader<C> {
    private final Yaml yaml;
    private final Class<C> clazz;

    public static <C> C readConfiguration(String fileName, Class<C> clazz) throws ConfigurationException {
        try {
            YamlLoader<C> loader = new YamlLoader<C>(clazz);
            return loader.load(Files.newInputStream(Paths.get(fileName, new String[0]), new OpenOption[0]), String.format("file '%s'", fileName));
        }
        catch (IOException ex) {
            throw new ConfigurationException(String.format("Error reading configuraion file '%s': %s", fileName, ex.getMessage()), ex);
        }
    }

    public static <C> C readConfiguration(InputStream in, Class<C> clazz) throws ConfigurationException {
        YamlLoader<C> loader = new YamlLoader<C>(clazz);
        return loader.load(in, "input stream");
    }

    private C load(InputStream in, String from) throws ConfigurationException {
        String PATTERN = "\\$\\{([A-Za-z_]+)\\}";
        StringBuilder buf = new StringBuilder();
        Pattern matchEnv = Pattern.compile("\\$\\{([A-Za-z_]+)\\}");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            Map<String, String> env = System.getenv();
            while (reader.ready()) {
                String line = reader.readLine();
                Matcher matcher = matchEnv.matcher(line);
                if (matcher.find()) {
                    String key = matcher.group(1);
                    if (env.containsKey(key)) {
                        line = line.replace(matcher.group(), env.get(key));
                    } else {
                        throw new ConfigurationException(String.format("Cannot find environment variable '%s'", key), new Object[0]);
                    }
                }
                buf.append(line);
                buf.append("\n");
            }
        }
        catch (IOException ex) {
            throw new ConfigurationException(String.format("Could not load configuration from %s' (%s)", from, ex.getMessage()), ex);
        }
        Object conf = this.yaml.loadAs(buf.toString(), this.clazz);
        if (conf == null) {
            throw new ConfigurationException(String.format("Could not load configuration from %s. Yaml returned null", from), new Object[0]);
        }
        this.validate(conf);
        return (C)conf;
    }

    private void validate(Object conf) throws ValidationException {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            Validator validator = factory.getValidator();
            Set errors = validator.validate(conf, new Class[0]);
            if (!errors.isEmpty()) {
                throw new ValidationException(((ConstraintViolation)errors.iterator().next()).getMessage(), new Object[]{errors});
            }
            Class<?> clazz = conf.getClass();
            if (clazz.isPrimitive() || clazz.isEnum() || conf instanceof Number || conf instanceof String || conf instanceof Boolean) {
                return;
            }
            if (conf instanceof Collection) {
                for (Object item : (Collection)conf) {
                    this.validate(item);
                }
                return;
            }
            if (conf instanceof Map) {
                for (Object item : ((Map)conf).values()) {
                    this.validate(item);
                }
                return;
            }
            for (Field field : conf.getClass().getDeclaredFields()) {
                Object val;
                if (field.isEnumConstant() || field.isSynthetic() || (val = this.get(field, conf)) == null) continue;
                this.validate(val);
            }
        }
        catch (IllegalArgumentException | AnnotationFormatError ex) {
            throw new ValidationException(ex.getMessage(), new Object[]{ex});
        }
    }

    private Object get(Field field, Object inst) throws ValidationException {
        if (field.isAccessible()) {
            try {
                return field.get(inst);
            }
            catch (IllegalArgumentException ex) {
                throw new ValidationException("Field '%s' is not found on object '%s'", field.getName(), inst.getClass().getSimpleName());
            }
            catch (IllegalAccessException ex) {
                throw new ValidationException("Field '%s' on '%s' is not accessible", field.getName(), inst.getClass().getSimpleName());
            }
        }
        String name = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        name = field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE) ? "is" + name : "get" + name;
        try {
            Method meth = inst.getClass().getDeclaredMethod(name, new Class[0]);
            return meth.invoke(inst, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new ValidationException("Field '%s' on '%s' does not have a get-method", field.getName(), inst.getClass().getSimpleName());
        }
        catch (SecurityException ex) {
            throw new ValidationException("Method '%s' on '%s' is in-accessible", name, inst.getClass().getSimpleName());
        }
        catch (IllegalAccessException ex) {
            throw new ValidationException("Method '%s' on '%s' is not accessible", name, inst.getClass().getSimpleName());
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException("Method '%s' is not found on object '%s'", name, inst.getClass().getSimpleName());
        }
        catch (InvocationTargetException ex) {
            throw new ValidationException(String.format("Error calling '%s' on object '%s': %s", name, inst.getClass().getSimpleName(), ex.getMessage()), new Object[]{ex});
        }
    }

    private YamlLoader(Class<C> clazz) {
        this.clazz = clazz;
        this.yaml = new Yaml();
        this.yaml.setBeanAccess(BeanAccess.FIELD);
    }
}

