/*
 * Decompiled with CFR 0.152.
 */
package org.liuxp.minioplus.extension.controller;

import cn.hutool.core.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.liuxp.minioplus.api.StorageService;
import org.liuxp.minioplus.api.model.vo.CompleteResultVo;
import org.liuxp.minioplus.api.model.vo.FileCheckResultVo;
import org.liuxp.minioplus.api.model.vo.FilePreShardingVo;
import org.liuxp.minioplus.common.enums.MinioPlusErrorCode;
import org.liuxp.minioplus.common.enums.StorageBucketEnums;
import org.liuxp.minioplus.common.exception.MinioPlusException;
import org.liuxp.minioplus.extension.context.Response;
import org.liuxp.minioplus.extension.context.UserHolder;
import org.liuxp.minioplus.extension.controller.StorageWebAPI;
import org.liuxp.minioplus.extension.dto.FileCheckDTO;
import org.liuxp.minioplus.extension.dto.FileCompleteDTO;
import org.liuxp.minioplus.extension.dto.PreShardingDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
@RequestMapping(value={"/storage"})
public class StorageController
implements StorageWebAPI {
    private static final Logger log = LoggerFactory.getLogger(StorageController.class);
    private static final String REDIRECT_PREFIX = "redirect:";
    private final StorageService storageService;

    public StorageController(StorageService storageService) {
        this.storageService = storageService;
    }

    public Response<FilePreShardingVo> sharding(@RequestBody @Validated PreShardingDTO preShardingDTO) {
        FilePreShardingVo resultVo = this.storageService.sharding(preShardingDTO.getFileSize().longValue());
        return Response.success((Object)resultVo);
    }

    public Response<FileCheckResultVo> init(FileCheckDTO fileCheckDTO) {
        String userId = UserHolder.get();
        FileCheckResultVo resultVo = this.storageService.init(fileCheckDTO.getFileMd5(), fileCheckDTO.getFullFileName(), fileCheckDTO.getFileSize().longValue(), fileCheckDTO.getIsPrivate(), userId);
        return Response.success((Object)resultVo);
    }

    public Response<Object> complete(String fileKey, FileCompleteDTO fileCompleteDTO) {
        String userId = UserHolder.get();
        log.debug("\u5408\u5e76\u6587\u4ef6\u5f00\u59cbfileKey=" + fileKey + ",partMd5List=" + fileCompleteDTO.getPartMd5List());
        CompleteResultVo completeResultVo = this.storageService.complete(fileKey, fileCompleteDTO.getPartMd5List(), userId);
        return Response.success((Object)completeResultVo);
    }

    public String download(String fileKey) {
        String userId = UserHolder.get();
        return REDIRECT_PREFIX + this.storageService.download(fileKey, userId);
    }

    public String previewOriginal(String fileKey) {
        String userId = UserHolder.get();
        return REDIRECT_PREFIX + this.storageService.image(fileKey, userId);
    }

    public String previewMedium(String fileKey) {
        String userId = UserHolder.get();
        String url = this.storageService.preview(fileKey, userId);
        if (url.length() < 10) {
            url = "/storage/icon/" + url;
        }
        return REDIRECT_PREFIX + url;
    }

    public void icon(String fileType) {
        try {
            String storageBucket = StorageBucketEnums.getBucketByFileSuffix((String)fileType, (String)"");
            ClassPathResource cpr = new ClassPathResource(storageBucket + ".png");
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)cpr.getInputStream());
            ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            attr.getResponse().setHeader("content-disposition", "inline");
            attr.getResponse().setHeader("Content-Length", String.valueOf(bytes.length));
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                IoUtil.copy((InputStream)inputStream, (OutputStream)attr.getResponse().getOutputStream());
            }
        }
        catch (Exception e) {
            log.error(MinioPlusErrorCode.FILE_ICON_FAILED.getMessage(), (Throwable)e);
            throw new MinioPlusException(MinioPlusErrorCode.FILE_ICON_FAILED);
        }
    }
}

