/*
 * Decompiled with CFR 0.152.
 */
package org.liuxp.minioplus.core.engine.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.coobird.thumbnailator.Thumbnails;
import org.liuxp.minioplus.api.model.bo.CreateUploadUrlReqBO;
import org.liuxp.minioplus.api.model.bo.CreateUploadUrlRespBO;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoDTO;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoSaveDTO;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoUpdateDTO;
import org.liuxp.minioplus.api.model.vo.CompleteResultVo;
import org.liuxp.minioplus.api.model.vo.FileCheckResultVo;
import org.liuxp.minioplus.api.model.vo.FileMetadataInfoVo;
import org.liuxp.minioplus.common.config.MinioPlusProperties;
import org.liuxp.minioplus.common.enums.MinioPlusErrorCode;
import org.liuxp.minioplus.common.enums.StorageBucketEnums;
import org.liuxp.minioplus.common.exception.MinioPlusException;
import org.liuxp.minioplus.core.common.utils.CommonUtil;
import org.liuxp.minioplus.core.engine.StorageEngineService;
import org.liuxp.minioplus.core.repository.MetadataRepository;
import org.liuxp.minioplus.s3.def.ListParts;
import org.liuxp.minioplus.s3.def.MinioS3Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StorageEngineServiceImpl
implements StorageEngineService {
    private static final Logger log = LoggerFactory.getLogger(StorageEngineServiceImpl.class);
    private final MetadataRepository metadataRepository;
    private final MinioPlusProperties properties;
    private final MinioS3Client minioS3Client;

    public StorageEngineServiceImpl(MetadataRepository metadataRepository, MinioPlusProperties properties, MinioS3Client minioS3Client) {
        this.metadataRepository = metadataRepository;
        this.properties = properties;
        this.minioS3Client = minioS3Client;
    }

    @Override
    public FileCheckResultVo init(String fileMd5, String fullFileName, long fileSize, Boolean isPrivate, String userId) {
        FileMetadataInfoDTO searchDTO = new FileMetadataInfoDTO();
        searchDTO.setFileMd5(fileMd5);
        List<FileMetadataInfoVo> list = this.metadataRepository.list(searchDTO);
        FileMetadataInfoSaveDTO saveDTO = new FileMetadataInfoSaveDTO();
        CreateUploadUrlReqBO bo = new CreateUploadUrlReqBO();
        if (CollUtil.isNotEmpty(list)) {
            for (FileMetadataInfoVo fileMetadataInfoVo : list) {
                if (!fileMetadataInfoVo.getIsFinished().booleanValue()) continue;
                saveDTO.setFileKey(IdUtil.fastSimpleUUID());
                saveDTO.setFileMd5(fileMd5);
                saveDTO.setFileName(fullFileName);
                saveDTO.setFileMimeType(fileMetadataInfoVo.getFileMimeType());
                saveDTO.setFileSuffix(fileMetadataInfoVo.getFileSuffix());
                saveDTO.setFileSize(fileMetadataInfoVo.getFileSize());
                saveDTO.setStorageBucket(fileMetadataInfoVo.getStorageBucket());
                saveDTO.setStoragePath(fileMetadataInfoVo.getStoragePath());
                saveDTO.setIsFinished(fileMetadataInfoVo.getIsFinished());
                saveDTO.setIsPreview(fileMetadataInfoVo.getIsPreview());
                saveDTO.setIsPrivate(isPrivate);
                saveDTO.setCreateUser(userId);
                saveDTO.setUpdateUser(userId);
                FileMetadataInfoVo metadataInfoVo = this.metadataRepository.save(saveDTO);
                return this.buildResult(metadataInfoVo, new ArrayList<FileCheckResultVo.Part>(1), 0, Boolean.TRUE);
            }
            Optional<FileMetadataInfoVo> userUploaded = list.stream().filter(item -> userId.equals(item.getCreateUser())).findFirst();
            boolean isSelf = userUploaded.isPresent();
            FileMetadataInfoVo uploadingMetadata = !isSelf ? list.stream().filter(FileMetadataInfoVo::getIsFinished).findAny().orElseGet(() -> list.stream().filter(item -> item.getIsFinished() == false).findFirst().get()) : userUploaded.get();
            bo.setIsSequel(Boolean.TRUE);
            CreateUploadUrlRespBO respBO = this.breakResume(uploadingMetadata);
            if (!isSelf) {
                BeanUtil.copyProperties((Object)uploadingMetadata, (Object)saveDTO, (String[])new String[0]);
                saveDTO.setFileName(fullFileName);
                saveDTO.setCreateUser(userId);
                saveDTO.setIsPrivate(isPrivate);
                saveDTO.setUploadTaskId(respBO.getUploadTaskId());
                FileMetadataInfoVo metadataInfoVo = this.metadataRepository.save(saveDTO);
                return this.buildResult(metadataInfoVo, respBO.getParts(), respBO.getPartCount(), Boolean.FALSE);
            }
            if (CollUtil.isNotEmpty((Collection)respBO.getParts()) && !respBO.getUploadTaskId().equals(uploadingMetadata.getUploadTaskId())) {
                uploadingMetadata.setUploadTaskId(respBO.getUploadTaskId());
                FileMetadataInfoUpdateDTO updateDTO = new FileMetadataInfoUpdateDTO();
                updateDTO.setId(uploadingMetadata.getId());
                updateDTO.setUploadTaskId(uploadingMetadata.getUploadTaskId());
                updateDTO.setUpdateUser(userId);
                this.metadataRepository.update(updateDTO);
            }
            return this.buildResult(uploadingMetadata, respBO.getParts(), respBO.getPartCount(), Boolean.FALSE);
        }
        bo.setFileMd5(fileMd5);
        bo.setFileSize(Long.valueOf(fileSize));
        bo.setFullFileName(fullFileName);
        CreateUploadUrlRespBO createUploadUrlRespBO = this.createUploadUrl(bo);
        FileMetadataInfoVo metadataInfo = this.saveMetadataInfo(saveDTO, createUploadUrlRespBO, fileMd5, fullFileName, fileSize, isPrivate, userId);
        return this.buildResult(metadataInfo, createUploadUrlRespBO.getParts(), createUploadUrlRespBO.getPartCount(), Boolean.FALSE);
    }

    private FileCheckResultVo buildResult(FileMetadataInfoVo metadataInfo, List<FileCheckResultVo.Part> partList, Integer partCount, Boolean isDone) {
        FileCheckResultVo fileCheckResultVo = new FileCheckResultVo();
        fileCheckResultVo.setId(metadataInfo.getId());
        fileCheckResultVo.setFileKey(metadataInfo.getFileKey());
        fileCheckResultVo.setFileMd5(metadataInfo.getFileMd5());
        fileCheckResultVo.setFileName(metadataInfo.getFileName());
        fileCheckResultVo.setFileMimeType(metadataInfo.getFileMimeType());
        fileCheckResultVo.setFileSuffix(metadataInfo.getFileSuffix());
        fileCheckResultVo.setFileSize(metadataInfo.getFileSize());
        fileCheckResultVo.setIsDone(isDone);
        fileCheckResultVo.setPartCount(partCount);
        fileCheckResultVo.setPartSize(Integer.valueOf(this.properties.getPart().getSize()));
        fileCheckResultVo.setPartList(partList);
        return fileCheckResultVo;
    }

    private FileMetadataInfoVo saveMetadataInfo(FileMetadataInfoSaveDTO saveDTO, CreateUploadUrlRespBO createUploadUrlRespBO, String fileMd5, String fullFileName, long fileSize, boolean isPrivate, String userId) {
        String suffix = FileUtil.getSuffix((String)fullFileName);
        saveDTO.setFileKey(createUploadUrlRespBO.getFileKey());
        saveDTO.setFileMd5(fileMd5);
        saveDTO.setFileName(fullFileName);
        saveDTO.setFileMimeType(FileUtil.getMimeType((String)fullFileName));
        saveDTO.setFileSuffix(suffix);
        saveDTO.setFileSize(Long.valueOf(fileSize));
        saveDTO.setStorageBucket(createUploadUrlRespBO.getBucketName());
        saveDTO.setStoragePath(createUploadUrlRespBO.getStoragePath());
        saveDTO.setUploadTaskId(createUploadUrlRespBO.getUploadTaskId());
        saveDTO.setIsFinished(Boolean.FALSE);
        saveDTO.setIsPart(Boolean.valueOf(createUploadUrlRespBO.getPartCount() > 1));
        saveDTO.setPartNumber(createUploadUrlRespBO.getPartCount());
        saveDTO.setIsPreview(Boolean.FALSE);
        saveDTO.setIsPrivate(Boolean.valueOf(isPrivate));
        saveDTO.setCreateUser(userId);
        saveDTO.setUpdateUser(userId);
        return this.metadataRepository.save(saveDTO);
    }

    @Override
    public CompleteResultVo complete(String fileKey, List<String> partMd5List, String userId) {
        CompleteResultVo completeResultVo = new CompleteResultVo();
        FileMetadataInfoDTO searchDto = new FileMetadataInfoDTO();
        searchDto.setCreateUser(userId);
        searchDto.setFileKey(fileKey);
        FileMetadataInfoVo metadata = this.metadataRepository.one(searchDto);
        if (metadata == null) {
            log.error(fileKey + MinioPlusErrorCode.FILE_EXIST_FAILED.getMessage());
            throw new MinioPlusException(MinioPlusErrorCode.FILE_EXIST_FAILED.getCode().intValue(), fileKey + MinioPlusErrorCode.FILE_EXIST_FAILED.getMessage());
        }
        if (Boolean.TRUE.equals(metadata.getIsFinished())) {
            completeResultVo.setIsComplete(Boolean.valueOf(true));
            return completeResultVo;
        }
        completeResultVo = this.completeMultipartUpload(metadata, partMd5List);
        if (Boolean.TRUE.equals(completeResultVo.getIsComplete())) {
            FileMetadataInfoUpdateDTO updateDTO = new FileMetadataInfoUpdateDTO();
            updateDTO.setId(metadata.getId());
            updateDTO.setIsFinished(Boolean.TRUE);
            updateDTO.setUpdateUser(metadata.getUpdateUser());
            this.metadataRepository.update(updateDTO);
            searchDto = new FileMetadataInfoDTO();
            searchDto.setFileMd5(metadata.getFileMd5());
            searchDto.setIsFinished(Boolean.valueOf(false));
            List<FileMetadataInfoVo> others = this.metadataRepository.list(searchDto);
            if (CollUtil.isNotEmpty(others)) {
                for (FileMetadataInfoVo other : others) {
                    updateDTO = new FileMetadataInfoUpdateDTO();
                    updateDTO.setId(other.getId());
                    updateDTO.setIsFinished(Boolean.TRUE);
                    updateDTO.setUpdateUser(metadata.getUpdateUser());
                    this.metadataRepository.update(updateDTO);
                }
            }
        } else if (!metadata.getUploadTaskId().equals(completeResultVo.getUploadTaskId())) {
            FileMetadataInfoUpdateDTO updateDTO = new FileMetadataInfoUpdateDTO();
            updateDTO.setId(metadata.getId());
            updateDTO.setUploadTaskId(completeResultVo.getUploadTaskId());
            updateDTO.setUpdateUser(metadata.getUpdateUser());
            this.metadataRepository.update(updateDTO);
        }
        return completeResultVo;
    }

    @Override
    public String download(String fileKey, String userId) {
        FileMetadataInfoVo metadata = this.getFileMetadataInfo(fileKey, userId);
        try {
            this.authentication(metadata, fileKey, userId);
            return this.minioS3Client.getDownloadUrl(metadata.getFileName(), metadata.getFileMimeType(), metadata.getStorageBucket(), metadata.getStoragePath() + "/" + metadata.getFileMd5());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new MinioPlusException(MinioPlusErrorCode.FILE_EXIST_FAILED);
        }
    }

    @Override
    public String image(String fileKey, String userId) {
        FileMetadataInfoVo metadata = this.getFileMetadataInfo(fileKey, userId);
        try {
            this.authentication(metadata, fileKey, userId);
            return this.minioS3Client.getPreviewUrl(metadata.getFileMimeType(), metadata.getStorageBucket(), metadata.getStoragePath() + "/" + metadata.getFileMd5());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new MinioPlusException(MinioPlusErrorCode.FILE_EXIST_FAILED);
        }
    }

    @Override
    public String preview(String fileKey, String userId) {
        FileMetadataInfoVo metadata = this.getFileMetadataInfo(fileKey, userId);
        try {
            this.authentication(metadata, fileKey, userId);
            String storageBucket = metadata.getStorageBucket();
            if (storageBucket == null || !storageBucket.contains(StorageBucketEnums.IMAGE.getCode())) {
                return metadata.getFileSuffix();
            }
            this.generatePreviewImage(metadata);
            return this.minioS3Client.getPreviewUrl(metadata.getFileMimeType(), StorageBucketEnums.getPreviewBucket((String)this.properties.getBucketPrefix()), metadata.getStoragePath() + "/" + metadata.getFileMd5());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new MinioPlusException(MinioPlusErrorCode.FILE_EXIST_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePreviewImage(FileMetadataInfoVo metadata) {
        block14: {
            try {
                if (!Boolean.FALSE.equals(metadata.getIsPreview())) break block14;
                byte[] imageOriginBytes = this.minioS3Client.getObject(metadata.getStorageBucket(), metadata.getStoragePath() + "/" + metadata.getFileMd5());
                ByteArrayInputStream imageOriginInputStream = new ByteArrayInputStream(imageOriginBytes);
                try {
                    ByteArrayOutputStream previewImage = new ByteArrayOutputStream();
                    try {
                        Thumbnails.of((InputStream[])new InputStream[]{imageOriginInputStream}).width(this.properties.getThumbnail().getSize()).outputQuality(0.9f).toOutputStream((OutputStream)previewImage);
                        byte[] previewImageBytes = previewImage.toByteArray();
                        ByteArrayInputStream previewImageInputStream = new ByteArrayInputStream(previewImageBytes);
                        try {
                            this.minioS3Client.putObject(StorageBucketEnums.getPreviewBucket((String)this.properties.getBucketPrefix()), CommonUtil.getObjectName(metadata.getFileMd5()), (InputStream)previewImageInputStream, (long)previewImageBytes.length, metadata.getFileMimeType());
                            metadata.setIsPreview(Boolean.TRUE);
                            FileMetadataInfoUpdateDTO fileMetadataInfoUpdateDTO = (FileMetadataInfoUpdateDTO)BeanUtil.copyProperties((Object)metadata, FileMetadataInfoUpdateDTO.class, (String[])new String[0]);
                            this.metadataRepository.update(fileMetadataInfoUpdateDTO);
                        }
                        finally {
                            if (Collections.singletonList(previewImageInputStream).get(0) != null) {
                                previewImageInputStream.close();
                            }
                        }
                    }
                    finally {
                        if (Collections.singletonList(previewImage).get(0) != null) {
                            previewImage.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(imageOriginInputStream).get(0) != null) {
                        imageOriginInputStream.close();
                    }
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new MinioPlusException(MinioPlusErrorCode.FILE_PREVIEW_WRITE_FAILED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean createFile(FileMetadataInfoSaveDTO saveDTO, byte[] fileBytes) {
        Boolean bl;
        block6: {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
            try {
                bl = this.createFile(saveDTO, inputStream);
                if (Collections.singletonList(inputStream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(inputStream).get(0) != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new MinioPlusException(MinioPlusErrorCode.FILE_CREATE_FAILED);
                }
            }
            inputStream.close();
        }
        return bl;
    }

    @Override
    public Boolean createFile(FileMetadataInfoSaveDTO saveDTO, InputStream inputStream) {
        this.minioS3Client.putObject(saveDTO.getStorageBucket(), CommonUtil.getObjectName(saveDTO.getFileMd5()), inputStream, saveDTO.getFileSize().longValue(), saveDTO.getFileMimeType());
        return true;
    }

    @Override
    public Pair<FileMetadataInfoVo, byte[]> read(String fileKey) {
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileKey(fileKey);
        FileMetadataInfoVo fileMetadataInfoVo = this.metadataRepository.one(fileMetadataInfo);
        if (null == fileMetadataInfoVo) {
            return null;
        }
        byte[] fileBytes = this.minioS3Client.getObject(fileMetadataInfoVo.getStorageBucket(), fileMetadataInfoVo.getStoragePath() + "/" + fileMetadataInfoVo.getFileMd5());
        return Pair.of((Object)fileMetadataInfoVo, (Object)fileBytes);
    }

    @Override
    public Boolean remove(String fileKey) {
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileKey(fileKey);
        FileMetadataInfoVo metadata = this.metadataRepository.one(fileMetadataInfo);
        if (null != metadata) {
            this.remove(metadata);
        }
        return true;
    }

    @Override
    public Boolean remove(String fileKey, String userId) {
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileKey(fileKey);
        FileMetadataInfoVo metadata = this.metadataRepository.one(fileMetadataInfo);
        if (null != metadata && userId.equals(metadata.getCreateUser())) {
            this.remove(metadata);
        }
        return true;
    }

    private void remove(FileMetadataInfoVo metadata) {
        this.metadataRepository.remove(metadata.getId());
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileMd5(metadata.getFileMd5());
        fileMetadataInfo.setIsFinished(Boolean.TRUE);
        FileMetadataInfoVo fileMetadataInfoVo = this.metadataRepository.one(fileMetadataInfo);
        if (null == fileMetadataInfoVo) {
            this.minioS3Client.removeObject(metadata.getStorageBucket(), metadata.getStoragePath() + "/" + metadata.getFileMd5());
            if (Boolean.TRUE.equals(metadata.getIsPreview())) {
                this.minioS3Client.removeObject(StorageBucketEnums.getPreviewBucket((String)this.properties.getBucketPrefix()), metadata.getStoragePath() + "/" + metadata.getFileMd5());
            }
        }
    }

    private FileMetadataInfoVo getFileMetadataInfo(String fileKey, String userId) {
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileKey(fileKey);
        FileMetadataInfoVo fileMetadataInfoVo = this.metadataRepository.one(fileMetadataInfo);
        if (null != fileMetadataInfoVo && (Boolean.FALSE.equals(fileMetadataInfoVo.getIsPrivate()) || fileMetadataInfoVo.getCreateUser().equals(userId))) {
            return fileMetadataInfoVo;
        }
        return null;
    }

    private void authentication(FileMetadataInfoVo metadata, String fileKey, String userId) {
        if (null == metadata) {
            throw new MinioPlusException(MinioPlusErrorCode.FILE_EXIST_FAILED.getCode().intValue(), fileKey + MinioPlusErrorCode.FILE_EXIST_FAILED.getMessage());
        }
        if (Boolean.TRUE.equals(metadata.getIsPrivate()) && !userId.equals(metadata.getCreateUser())) {
            throw new MinioPlusException(MinioPlusErrorCode.FILE_PERMISSION_CHECK_FAILED.getCode().intValue(), fileKey + "\u7528\u6237" + userId + MinioPlusErrorCode.FILE_PERMISSION_CHECK_FAILED.getMessage());
        }
    }

    @Override
    public Integer computeChunkNum(Long fileSize) {
        double tempNum = (double)fileSize.longValue() / (double)this.properties.getPart().getSize();
        return Double.valueOf(Math.ceil(tempNum)).intValue();
    }

    private FileCheckResultVo.Part buildResultPart(String bucketName, String objectName, String uploadId, Long fileSize, long start, Integer partNumber) {
        long end = Math.min(start + (long)this.properties.getPart().getSize(), fileSize);
        String uploadUrl = this.minioS3Client.getUploadObjectUrl(bucketName, objectName, uploadId, String.valueOf(partNumber));
        FileCheckResultVo.Part part = new FileCheckResultVo.Part();
        part.setUploadId(uploadId);
        part.setUrl(uploadUrl);
        part.setStartPosition(Long.valueOf(start));
        part.setEndPosition(Long.valueOf(end));
        return part;
    }

    public CreateUploadUrlRespBO breakResume(FileMetadataInfoVo fileMetadataVo) {
        CreateUploadUrlRespBO result = new CreateUploadUrlRespBO();
        result.setParts(new ArrayList());
        result.setPartCount(fileMetadataVo.getPartNumber());
        Integer chunkNum = fileMetadataVo.getPartNumber();
        ListParts listParts = this.buildResultPart(fileMetadataVo);
        List parts = listParts.getPartList();
        if (!chunkNum.equals(parts.size())) {
            boolean[] exists = new boolean[chunkNum + 1];
            for (ListParts.Part item : parts) {
                int partNumber = item.getPartNumber();
                exists[partNumber] = true;
            }
            ArrayList<Integer> missingNumbers = new ArrayList<Integer>();
            for (int i = 1; i <= chunkNum; ++i) {
                if (exists[i]) continue;
                missingNumbers.add(i);
            }
            CreateUploadUrlReqBO bo = new CreateUploadUrlReqBO();
            bo.setFileMd5(fileMetadataVo.getFileMd5());
            bo.setFullFileName(fileMetadataVo.getFileName());
            bo.setFileSize(fileMetadataVo.getFileSize());
            bo.setIsSequel(Boolean.TRUE);
            bo.setMissPartNum(missingNumbers);
            if (missingNumbers.size() != chunkNum.intValue()) {
                bo.setUploadId(fileMetadataVo.getUploadTaskId());
            }
            bo.setStorageBucket(fileMetadataVo.getStorageBucket());
            bo.setStoragePath(fileMetadataVo.getStoragePath());
            bo.setFileKey(fileMetadataVo.getFileKey());
            result = this.createUploadUrl(bo);
        }
        return result;
    }

    public CompleteResultVo completeMultipartUpload(FileMetadataInfoVo metadataInfo, List<String> partMd5List) {
        CompleteResultVo completeResultVo = new CompleteResultVo();
        ListParts listParts = this.buildResultPart(metadataInfo);
        ArrayList<Integer> missingNumbers = new ArrayList<Integer>();
        Integer chunkNum = metadataInfo.getPartNumber();
        if (partMd5List == null || chunkNum.intValue() != partMd5List.size()) {
            throw new MinioPlusException(MinioPlusErrorCode.FILE_PART_NUM_CHECK_FAILED);
        }
        for (int i = 1; i <= chunkNum; ++i) {
            boolean findPart = false;
            for (ListParts.Part part : listParts.getPartList()) {
                if (part.getPartNumber() != i || !CharSequenceUtil.equalsIgnoreCase((CharSequence)part.getEtag(), (CharSequence)partMd5List.get(i - 1))) continue;
                findPart = true;
            }
            if (findPart) continue;
            missingNumbers.add(i);
        }
        if (CollUtil.isNotEmpty(missingNumbers)) {
            CreateUploadUrlReqBO bo = new CreateUploadUrlReqBO();
            bo.setFileMd5(metadataInfo.getFileMd5());
            bo.setFullFileName(metadataInfo.getFileName());
            bo.setFileSize(metadataInfo.getFileSize());
            bo.setIsSequel(Boolean.TRUE);
            bo.setMissPartNum(missingNumbers);
            if (missingNumbers.size() != chunkNum.intValue()) {
                bo.setUploadId(metadataInfo.getUploadTaskId());
            }
            bo.setStorageBucket(metadataInfo.getStorageBucket());
            bo.setStoragePath(metadataInfo.getStoragePath());
            bo.setFileKey(metadataInfo.getFileKey());
            CreateUploadUrlRespBO createUploadUrlRespBO = this.createUploadUrl(bo);
            completeResultVo.setIsComplete(Boolean.valueOf(false));
            completeResultVo.setUploadTaskId(createUploadUrlRespBO.getUploadTaskId());
            completeResultVo.setPartList(createUploadUrlRespBO.getParts());
        } else {
            boolean writeResponse = this.minioS3Client.completeMultipartUpload(metadataInfo.getStorageBucket(), listParts.getObjectName(), metadataInfo.getUploadTaskId(), listParts.getPartList());
            completeResultVo.setIsComplete(Boolean.valueOf(writeResponse));
            completeResultVo.setPartList(new ArrayList());
        }
        return completeResultVo;
    }

    private ListParts buildResultPart(FileMetadataInfoVo metadataInfo) {
        String objectName = CommonUtil.getObjectName(metadataInfo.getFileMd5());
        return this.minioS3Client.listParts(metadataInfo.getStorageBucket(), objectName, metadataInfo.getPartNumber(), metadataInfo.getUploadTaskId());
    }

    public CreateUploadUrlRespBO createUploadUrl(CreateUploadUrlReqBO bo) {
        String uploadId;
        String fileKey;
        String storagePath;
        String bucketName;
        Integer chunkNum = this.computeChunkNum(bo.getFileSize());
        ArrayList<FileCheckResultVo.Part> partList = new ArrayList<FileCheckResultVo.Part>();
        if (Boolean.TRUE.equals(bo.getIsSequel()) && CollUtil.isNotEmpty((Collection)bo.getMissPartNum()) && CharSequenceUtil.isNotBlank((CharSequence)bo.getUploadId())) {
            bucketName = bo.getStorageBucket();
            storagePath = CommonUtil.getObjectName(bo.getFileMd5());
            fileKey = bo.getFileKey();
            uploadId = bo.getUploadId();
            long start = (long)((Integer)bo.getMissPartNum().get(0) - 1) * (long)this.properties.getPart().getSize();
            Iterator iterator = bo.getMissPartNum().iterator();
            while (iterator.hasNext()) {
                int partNumber = (Integer)iterator.next();
                FileCheckResultVo.Part part = this.buildResultPart(bucketName, storagePath, uploadId, bo.getFileSize(), start, partNumber);
                start += (long)this.properties.getPart().getSize();
                partList.add(part);
            }
        } else {
            String suffix = FileUtil.getSuffix((String)bo.getFullFileName());
            if (CharSequenceUtil.isBlank((CharSequence)suffix)) {
                throw new MinioPlusException(MinioPlusErrorCode.FILE_SUFFIX_GET_FAILED);
            }
            fileKey = IdUtil.fastSimpleUUID();
            storagePath = CommonUtil.getPathByDate();
            String fileMimeType = FileUtil.getMimeType((String)bo.getFullFileName());
            bucketName = StorageBucketEnums.getBucketByFileSuffix((String)suffix, (String)this.properties.getBucketPrefix());
            this.minioS3Client.makeBucket(bucketName);
            uploadId = this.minioS3Client.createMultipartUpload(bucketName, CommonUtil.getObjectName(bo.getFileMd5()), fileMimeType);
            long start = 0L;
            Integer partNumber = 1;
            while (partNumber <= chunkNum) {
                FileCheckResultVo.Part part = this.buildResultPart(bucketName, CommonUtil.getObjectName(bo.getFileMd5()), uploadId, bo.getFileSize(), start, partNumber);
                start += (long)this.properties.getPart().getSize();
                partList.add(part);
                Integer n = partNumber;
                partNumber = partNumber + 1;
            }
        }
        CreateUploadUrlRespBO respBO = new CreateUploadUrlRespBO();
        respBO.setBucketName(bucketName);
        respBO.setStoragePath(storagePath);
        respBO.setFileKey(fileKey);
        respBO.setPartCount(chunkNum);
        respBO.setUploadTaskId(uploadId);
        respBO.setParts(partList);
        return respBO;
    }
}

