/*
 * Decompiled with CFR 0.152.
 */
package org.liuxp.minioplus.core.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.liuxp.minioplus.api.StorageService;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoDTO;
import org.liuxp.minioplus.api.model.dto.FileMetadataInfoSaveDTO;
import org.liuxp.minioplus.api.model.vo.CompleteResultVo;
import org.liuxp.minioplus.api.model.vo.FileCheckResultVo;
import org.liuxp.minioplus.api.model.vo.FileMetadataInfoVo;
import org.liuxp.minioplus.api.model.vo.FilePreShardingVo;
import org.liuxp.minioplus.common.config.MinioPlusProperties;
import org.liuxp.minioplus.common.enums.MinioPlusErrorCode;
import org.liuxp.minioplus.common.enums.StorageBucketEnums;
import org.liuxp.minioplus.common.exception.MinioPlusException;
import org.liuxp.minioplus.core.common.utils.CommonUtil;
import org.liuxp.minioplus.core.common.utils.ContentTypeUtil;
import org.liuxp.minioplus.core.engine.StorageEngineService;
import org.liuxp.minioplus.core.repository.MetadataRepository;
import org.springframework.stereotype.Service;

@Service
public class StorageServiceImpl
implements StorageService {
    private final StorageEngineService storageEngineService;
    private final MetadataRepository fileMetadataRepository;
    private final MinioPlusProperties properties;

    public StorageServiceImpl(StorageEngineService storageEngineService, MetadataRepository fileMetadataRepository, MinioPlusProperties properties) {
        this.storageEngineService = storageEngineService;
        this.fileMetadataRepository = fileMetadataRepository;
        this.properties = properties;
    }

    public FilePreShardingVo sharding(long fileSize) {
        Integer chunkNum = this.storageEngineService.computeChunkNum(fileSize);
        ArrayList<FilePreShardingVo.Part> partList = new ArrayList<FilePreShardingVo.Part>();
        long start = 0L;
        for (int partNumber = 1; partNumber <= chunkNum; ++partNumber) {
            long end = Math.min(start + (long)this.properties.getPart().getSize(), fileSize);
            FilePreShardingVo.Part part = new FilePreShardingVo.Part();
            part.setStartPosition(Long.valueOf(start));
            part.setEndPosition(Long.valueOf(end));
            start += (long)this.properties.getPart().getSize();
            partList.add(part);
        }
        FilePreShardingVo filePreShardingVo = new FilePreShardingVo();
        filePreShardingVo.setFileSize(Long.valueOf(fileSize));
        filePreShardingVo.setPartCount(chunkNum);
        filePreShardingVo.setPartSize(Integer.valueOf(this.properties.getPart().getSize()));
        filePreShardingVo.setPartList(partList);
        return filePreShardingVo;
    }

    public FileCheckResultVo init(String fileMd5, String fullFileName, long fileSize, Boolean isPrivate, String userId) {
        FileCheckResultVo resultVo = this.storageEngineService.init(fileMd5, fullFileName, fileSize, isPrivate = Boolean.valueOf(isPrivate != null && isPrivate != false), userId);
        if (resultVo != null) {
            for (FileCheckResultVo.Part part : resultVo.getPartList()) {
                part.setUrl(this.remakeUrl(part.getUrl()));
            }
        }
        return resultVo;
    }

    public CompleteResultVo complete(String fileKey, List<String> partMd5List, String userId) {
        CompleteResultVo completeResultVo = this.storageEngineService.complete(fileKey, partMd5List, userId);
        if (completeResultVo != null) {
            for (FileCheckResultVo.Part part : completeResultVo.getPartList()) {
                part.setUrl(this.remakeUrl(part.getUrl()));
            }
        }
        return completeResultVo;
    }

    public String download(String fileKey, String userId) {
        return this.remakeUrl(this.storageEngineService.download(fileKey, userId));
    }

    public String image(String fileKey, String userId) {
        return this.remakeUrl(this.storageEngineService.image(fileKey, userId));
    }

    public String preview(String fileKey, String userId) {
        return this.remakeUrl(this.storageEngineService.preview(fileKey, userId));
    }

    public FileMetadataInfoVo one(String key) {
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileKey(key);
        return this.fileMetadataRepository.one(fileMetadataInfo);
    }

    public List<FileMetadataInfoVo> list(FileMetadataInfoDTO fileMetadataInfo) {
        return this.fileMetadataRepository.list(fileMetadataInfo);
    }

    public FileMetadataInfoVo createFile(String fullFileName, Boolean isPrivate, String userId, byte[] fileBytes) {
        FileMetadataInfoSaveDTO saveDTO = this.buildSaveDto(fullFileName, isPrivate, userId, fileBytes);
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileMd5(saveDTO.getFileMd5());
        fileMetadataInfo.setIsFinished(Boolean.valueOf(true));
        FileMetadataInfoVo alreadyFile = this.fileMetadataRepository.one(fileMetadataInfo);
        if (null != alreadyFile) {
            saveDTO.setStorageBucket(alreadyFile.getStorageBucket());
            saveDTO.setStoragePath(alreadyFile.getStoragePath());
        } else {
            this.storageEngineService.createFile(saveDTO, fileBytes);
        }
        return this.fileMetadataRepository.save(saveDTO);
    }

    public FileMetadataInfoVo createFile(String fullFileName, Boolean isPrivate, String userId, InputStream inputStream) {
        return this.createFile(fullFileName, isPrivate, userId, IoUtil.readBytes((InputStream)inputStream));
    }

    public FileMetadataInfoVo createFile(String fullFileName, Boolean isPrivate, String userId, String url) {
        HttpResponse httpResponse = HttpUtil.createGet((String)url).execute();
        InputStream inputStream = httpResponse.bodyStream();
        return this.createFile(fullFileName, isPrivate, userId, inputStream);
    }

    public FileMetadataInfoVo createBigFile(String fullFileName, String md5, long fileSize, Boolean isPrivate, String userId, InputStream inputStream) {
        FileMetadataInfoSaveDTO saveDTO = this.buildSaveDto(fullFileName, md5, fileSize, isPrivate, userId);
        FileMetadataInfoDTO fileMetadataInfo = new FileMetadataInfoDTO();
        fileMetadataInfo.setFileMd5(saveDTO.getFileMd5());
        fileMetadataInfo.setIsFinished(Boolean.valueOf(true));
        FileMetadataInfoVo alreadyFile = this.fileMetadataRepository.one(fileMetadataInfo);
        if (null != alreadyFile) {
            saveDTO.setStorageBucket(alreadyFile.getStorageBucket());
            saveDTO.setStoragePath(alreadyFile.getStoragePath());
        } else {
            this.storageEngineService.createFile(saveDTO, inputStream);
        }
        return this.fileMetadataRepository.save(saveDTO);
    }

    public Pair<FileMetadataInfoVo, byte[]> read(String fileKey) {
        return this.storageEngineService.read(fileKey);
    }

    public Boolean remove(String fileKey) {
        return this.storageEngineService.remove(fileKey);
    }

    FileMetadataInfoSaveDTO buildSaveDto(String fullFileName, Boolean isPrivate, String userId, byte[] fileBytes) {
        if (null == fileBytes) {
            throw new MinioPlusException(MinioPlusErrorCode.FILE_BYTES_FAILED);
        }
        String md5 = SecureUtil.md5().digestHex(fileBytes);
        return this.buildSaveDto(fullFileName, md5, fileBytes.length, isPrivate, userId);
    }

    FileMetadataInfoSaveDTO buildSaveDto(String fullFileName, String md5, long fileSize, Boolean isPrivate, String userId) {
        String key = IdUtil.fastSimpleUUID();
        String suffix = FileUtil.getSuffix((String)fullFileName);
        String fileMimeType = ContentTypeUtil.getContentType(suffix);
        String storageBucket = StorageBucketEnums.getBucketByFileSuffix((String)suffix, (String)this.properties.getBucketPrefix());
        String storagePath = CommonUtil.getPathByDate();
        Boolean isPreview = this.properties.getThumbnail().isEnable() && StorageBucketEnums.IMAGE.getCode().equals(storageBucket);
        FileMetadataInfoSaveDTO fileMetadataInfoSaveDTO = new FileMetadataInfoSaveDTO();
        fileMetadataInfoSaveDTO.setFileKey(key);
        fileMetadataInfoSaveDTO.setFileMd5(md5);
        fileMetadataInfoSaveDTO.setFileName(fullFileName);
        fileMetadataInfoSaveDTO.setFileMimeType(fileMimeType);
        fileMetadataInfoSaveDTO.setFileSuffix(suffix);
        fileMetadataInfoSaveDTO.setFileSize(Long.valueOf(fileSize));
        fileMetadataInfoSaveDTO.setStorageBucket(storageBucket);
        fileMetadataInfoSaveDTO.setStoragePath(storagePath);
        fileMetadataInfoSaveDTO.setUploadTaskId("");
        fileMetadataInfoSaveDTO.setIsFinished(Boolean.valueOf(true));
        fileMetadataInfoSaveDTO.setIsPart(Boolean.valueOf(false));
        fileMetadataInfoSaveDTO.setPartNumber(Integer.valueOf(0));
        fileMetadataInfoSaveDTO.setIsPreview(isPreview);
        fileMetadataInfoSaveDTO.setIsPrivate(isPrivate);
        fileMetadataInfoSaveDTO.setCreateUser(userId);
        fileMetadataInfoSaveDTO.setUpdateUser(userId);
        return fileMetadataInfoSaveDTO;
    }

    private String remakeUrl(String url) {
        if (CharSequenceUtil.isNotBlank((CharSequence)this.properties.getBrowserUrl())) {
            return url.replace(this.properties.getBackend(), this.properties.getBrowserUrl());
        }
        return url;
    }
}

