/*
 * Decompiled with CFR 0.152.
 */
package org.liuxp.minioplus.extension.context;

import io.swagger.v3.oas.annotations.media.Schema;
import org.liuxp.minioplus.extension.context.ResponseCodeEnum;

@Schema(description="Response")
public class Response<T> {
    @Schema(description="\u72b6\u6001\u7801")
    protected int code;
    @Schema(description="\u64cd\u4f5c\u6210\u529f")
    protected String message;
    @Schema(description="\u54cd\u5e94\u4e1a\u52a1\u53c2\u6570")
    protected T data;

    public Response() {
        this.setCode(ResponseCodeEnum.SUCCESS.getCode());
        this.setMessage(ResponseCodeEnum.SUCCESS.getMessage());
    }

    public static Response<Void> success() {
        Response<Void> response = new Response<Void>();
        response.setCode(ResponseCodeEnum.SUCCESS.getCode());
        response.setMessage(ResponseCodeEnum.SUCCESS.getMessage());
        return response;
    }

    public static <T> Response<T> success(T data) {
        Response<T> response = new Response<T>();
        response.setCode(ResponseCodeEnum.SUCCESS.getCode());
        response.setMessage(ResponseCodeEnum.SUCCESS.getMessage());
        response.setData(data);
        return response;
    }

    public static <T> Response<T> error(Integer errorCode, String message) {
        Response<T> response = new Response<T>();
        response.setCode(errorCode);
        response.setMessage(message);
        return response;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

