/*
 * Decompiled with CFR 0.152.
 */
package org.liuxp.minioplus.s3.def;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class ListParts {
    private String bucketName;
    private String objectName;
    private int maxParts;
    private String uploadId;
    private List<Part> partList = null;

    public static ListParts build() {
        ListParts listParts = new ListParts();
        listParts.setPartList(new ArrayList<Part>());
        return listParts;
    }

    public void addPart(int partNumber, String etag, ZonedDateTime lastModified, Long size) {
        Part part = new Part();
        part.setPartNumber(partNumber);
        part.setEtag(etag);
        part.setLastModified(lastModified);
        part.setSize(size);
        if (this.partList == null) {
            this.partList = new ArrayList<Part>();
        }
        this.partList.add(part);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public int getMaxParts() {
        return this.maxParts;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public List<Part> getPartList() {
        return this.partList;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setMaxParts(int maxParts) {
        this.maxParts = maxParts;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public void setPartList(List<Part> partList) {
        this.partList = partList;
    }

    public String toString() {
        return "ListParts(bucketName=" + this.getBucketName() + ", objectName=" + this.getObjectName() + ", maxParts=" + this.getMaxParts() + ", uploadId=" + this.getUploadId() + ", partList=" + this.getPartList() + ")";
    }

    public static class Part {
        private int partNumber;
        private String etag;
        private ZonedDateTime lastModified;
        private Long size;

        public int getPartNumber() {
            return this.partNumber;
        }

        public String getEtag() {
            return this.etag;
        }

        public ZonedDateTime getLastModified() {
            return this.lastModified;
        }

        public Long getSize() {
            return this.size;
        }

        public void setPartNumber(int partNumber) {
            this.partNumber = partNumber;
        }

        public void setEtag(String etag) {
            this.etag = etag;
        }

        public void setLastModified(ZonedDateTime lastModified) {
            this.lastModified = lastModified;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        public String toString() {
            return "ListParts.Part(partNumber=" + this.getPartNumber() + ", etag=" + this.getEtag() + ", lastModified=" + this.getLastModified() + ", size=" + this.getSize() + ")";
        }
    }
}

