/*
 * Decompiled with CFR 0.152.
 */
package org.liuxp.minioplus.s3.official;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.minio.BucketExistsArgs;
import io.minio.CreateMultipartUploadResponse;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListPartsResponse;
import io.minio.MakeBucketArgs;
import io.minio.MinioAsyncClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.XmlParserException;
import io.minio.http.Method;
import io.minio.messages.Part;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.liuxp.minioplus.common.config.MinioPlusProperties;
import org.liuxp.minioplus.common.enums.MinioPlusErrorCode;
import org.liuxp.minioplus.common.exception.MinioPlusException;
import org.liuxp.minioplus.s3.def.ListParts;
import org.liuxp.minioplus.s3.def.MinioS3Client;
import org.liuxp.minioplus.s3.official.CustomMinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioS3ClientImpl
implements MinioS3Client {
    private static final Logger log = LoggerFactory.getLogger(MinioS3ClientImpl.class);
    private static final String UPLOAD_ID = "uploadId";
    private static final String PART_NUMBER = "partNumber";
    private static final String LOG_TEMPLATE = "{}:{}";
    private final MinioPlusProperties properties;
    private CustomMinioClient minioClient = null;

    public MinioS3ClientImpl(MinioPlusProperties properties) {
        this.properties = properties;
    }

    public CustomMinioClient getClient() {
        if (null == this.minioClient) {
            MinioAsyncClient client = MinioAsyncClient.builder().endpoint(this.properties.getBackend()).credentials(this.properties.getKey(), this.properties.getSecret()).build();
            this.minioClient = new CustomMinioClient(client);
        }
        return this.minioClient;
    }

    public Boolean bucketExists(String bucketName) {
        try {
            return (Boolean)this.getClient().bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build()).get();
        }
        catch (InsufficientDataException | InternalException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException | ExecutionException e) {
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.BUCKET_EXISTS_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.BUCKET_EXISTS_FAILED);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.BUCKET_EXISTS_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.BUCKET_EXISTS_FAILED);
        }
    }

    public void makeBucket(String bucketName) {
        boolean found = this.bucketExists(bucketName);
        try {
            if (!found) {
                log.info("create bucket: [{}]", (Object)bucketName);
                this.getClient().makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            }
        }
        catch (Exception e) {
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.MAKE_BUCKET_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.MAKE_BUCKET_FAILED);
        }
    }

    public String createMultipartUpload(String bucketName, String objectName, String contentType) {
        HashMultimap reqParams = HashMultimap.create();
        if (CharSequenceUtil.isNotBlank((CharSequence)contentType)) {
            reqParams.put((Object)"Content-Type", (Object)contentType);
        }
        try {
            CreateMultipartUploadResponse createMultipartUploadResponse = this.getClient().createMultipartUpload(bucketName, null, objectName, (Multimap<String, String>)reqParams, null);
            return createMultipartUploadResponse.result().uploadId();
        }
        catch (Exception e) {
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.CREATE_MULTIPART_UPLOAD_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.CREATE_MULTIPART_UPLOAD_FAILED);
        }
    }

    public Boolean completeMultipartUpload(String bucketName, String objectName, String uploadId, List<ListParts.Part> parts) {
        Part[] partArray = new Part[parts.size()];
        for (int i = 0; i < parts.size(); ++i) {
            partArray[i] = new Part(parts.get(i).getPartNumber(), parts.get(i).getEtag());
        }
        try {
            ObjectWriteResponse objectWriteResponse = this.getClient().completeMultipartUpload(bucketName, null, objectName, uploadId, partArray, null, null);
            return objectWriteResponse != null;
        }
        catch (Exception e) {
            log.error("{},uploadId:{},ObjectName:{},\u5931\u8d25\u539f\u56e0:{},", new Object[]{MinioPlusErrorCode.COMPLETE_MULTIPART_FAILED.getMessage(), uploadId, objectName, e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.COMPLETE_MULTIPART_FAILED);
        }
    }

    public ListParts listParts(String bucketName, String objectName, Integer maxParts, String uploadId) {
        ListParts listParts = ListParts.build();
        try {
            ListPartsResponse listPartsResponse = this.getClient().listParts(bucketName, null, objectName, maxParts, 0, uploadId, null, null);
            listParts.setBucketName(bucketName);
            listParts.setObjectName(objectName);
            listParts.setMaxParts(maxParts.intValue());
            listParts.setUploadId(uploadId);
            listParts.setPartList(new ArrayList());
            for (Part part : listPartsResponse.result().partList()) {
                listParts.addPart(part.partNumber(), part.etag(), part.lastModified(), Long.valueOf(part.partSize()));
            }
        }
        catch (Exception e) {
            log.error(LOG_TEMPLATE, (Object)MinioPlusErrorCode.LIST_PARTS_FAILED.getMessage(), (Object)e.getMessage());
        }
        return listParts;
    }

    public String getUploadObjectUrl(String bucketName, String objectName, String uploadId, String partNumber) {
        HashMap queryParams = Maps.newHashMapWithExpectedSize((int)2);
        queryParams.put(UPLOAD_ID, uploadId);
        queryParams.put(PART_NUMBER, partNumber);
        try {
            return this.getClient().getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.PUT).bucket(bucketName)).object(objectName)).expiry(this.properties.getUploadExpiry().intValue(), TimeUnit.MINUTES).extraQueryParams((Map)queryParams)).build());
        }
        catch (Exception e) {
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.CREATE_UPLOAD_URL_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.CREATE_UPLOAD_URL_FAILED);
        }
    }

    public String getDownloadUrl(String fileName, String contentType, String bucketName, String objectName) {
        HashMap<String, String> reqParams = new HashMap<String, String>();
        reqParams.put("response-content-disposition", "attachment;filename=\"" + fileName + "\"");
        reqParams.put("response-content-type", contentType);
        try {
            return this.getClient().getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(this.properties.getDownloadExpiry().intValue(), TimeUnit.MINUTES).extraQueryParams(reqParams)).build());
        }
        catch (Exception e) {
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.CREATE_DOWNLOAD_URL_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.CREATE_DOWNLOAD_URL_FAILED);
        }
    }

    public String getPreviewUrl(String contentType, String bucketName, String objectName) {
        HashMap<String, String> reqParams = new HashMap<String, String>();
        reqParams.put("response-content-type", contentType);
        reqParams.put("response-content-disposition", "inline");
        try {
            return this.getClient().getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(this.properties.getDownloadExpiry().intValue(), TimeUnit.MINUTES).extraQueryParams(reqParams)).build());
        }
        catch (Exception e) {
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.CREATE_PREVIEW_URL_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.CREATE_PREVIEW_URL_FAILED);
        }
    }

    public Boolean putObject(String bucketName, String objectName, InputStream stream, long size, String contentType) {
        try {
            boolean isExist = (Boolean)this.getClient().bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build()).get();
            if (!isExist) {
                this.getClient().makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            }
            this.getClient().putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, size, 0L).contentType(contentType).build());
        }
        catch (InsufficientDataException | InternalException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException | ExecutionException e) {
            log.error(MinioPlusErrorCode.WRITE_FAILED.getMessage(), e);
            throw new MinioPlusException(MinioPlusErrorCode.WRITE_FAILED);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(LOG_TEMPLATE, new Object[]{MinioPlusErrorCode.BUCKET_EXISTS_FAILED.getMessage(), e.getMessage(), e});
            throw new MinioPlusException(MinioPlusErrorCode.BUCKET_EXISTS_FAILED);
        }
        return true;
    }

    public byte[] getObject(String bucketName, String objectName) {
        byte[] byArray;
        block8: {
            InputStream inputStream = (InputStream)this.getClient().getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build()).get();
            try {
                byArray = IoUtil.readBytes((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(MinioPlusErrorCode.READ_FAILED.getMessage(), (Throwable)e);
                    throw new MinioPlusException(MinioPlusErrorCode.READ_FAILED);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public void removeObject(String bucketName, String objectName) {
        try {
            this.getClient().removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        }
        catch (Exception e) {
            log.error(MinioPlusErrorCode.DELETE_FAILED.getMessage(), (Throwable)e);
            throw new MinioPlusException(MinioPlusErrorCode.DELETE_FAILED);
        }
    }
}

