/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.profiles.Profile;

public final class ImmutableProfile
implements Profile {
    @Nonnull
    private final UUID uniqueId;
    @Nullable
    private final String name;
    private final long timestamp;

    public ImmutableProfile(@Nonnull UUID uniqueId, @Nullable String name, long timestamp) {
        this.uniqueId = Objects.requireNonNull(uniqueId, "uniqueId");
        this.name = name;
        this.timestamp = timestamp;
    }

    public ImmutableProfile(@Nonnull UUID uniqueId, @Nullable String name) {
        this(uniqueId, name, System.currentTimeMillis());
    }

    @Nonnull
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Nonnull
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)o;
        return this.getUniqueId().equals(other.getUniqueId()) && this.getName().equals(other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.name);
    }

    public String toString() {
        return "Profile(uniqueId=" + this.uniqueId + ", name=" + this.name + ")";
    }
}

