/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin.external.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.AccessOrderDeque;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.WriteOrderDeque;

abstract class Node<K, V>
implements AccessOrderDeque.AccessOrder<Node<K, V>>,
WriteOrderDeque.WriteOrder<Node<K, V>> {
    public static final int EDEN = 0;
    public static final int PROBATION = 1;
    public static final int PROTECTED = 2;

    Node() {
    }

    @Nullable
    public abstract K getKey();

    @Nonnull
    public abstract Object getKeyReference();

    @Nullable
    public abstract V getValue();

    @Nonnull
    public abstract Object getValueReference();

    @GuardedBy(value="this")
    public abstract void setValue(@Nonnull V var1, @Nullable ReferenceQueue<V> var2);

    public abstract boolean containsValue(@Nonnull Object var1);

    @Nonnegative
    @GuardedBy(value="this")
    public int getWeight() {
        return 1;
    }

    @Nonnegative
    @GuardedBy(value="this")
    public void setWeight(int weight) {
    }

    @Nonnegative
    @GuardedBy(value="evictionLock")
    public int getPolicyWeight() {
        return 1;
    }

    @Nonnegative
    @GuardedBy(value="evictionLock")
    public void setPolicyWeight(int weight) {
    }

    @GuardedBy(value="this")
    public abstract boolean isAlive();

    @GuardedBy(value="this")
    public abstract boolean isRetired();

    @GuardedBy(value="this")
    public abstract boolean isDead();

    @GuardedBy(value="this")
    public abstract void retire();

    @GuardedBy(value="this")
    public abstract void die();

    public long getVariableTime() {
        return 0L;
    }

    public void setVariableTime(long time) {
    }

    @GuardedBy(value="evictionLock")
    public Node<K, V> getPreviousInVariableOrder() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    public void setPreviousInVariableOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    public Node<K, V> getNextInVariableOrder() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    public void setNextInVariableOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    public boolean inEden() {
        return this.getQueueType() == 0;
    }

    public boolean inMainProbation() {
        return this.getQueueType() == 1;
    }

    public boolean inMainProtected() {
        return this.getQueueType() == 2;
    }

    public void makeMainProbation() {
        this.setQueueType(1);
    }

    public void makeMainProtected() {
        this.setQueueType(2);
    }

    public int getQueueType() {
        return 0;
    }

    public void setQueueType(int queueType) {
        throw new UnsupportedOperationException();
    }

    public long getAccessTime() {
        return 0L;
    }

    public void setAccessTime(long time) {
    }

    @Override
    @Nullable
    @GuardedBy(value="evictionLock")
    public Node<K, V> getPreviousInAccessOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    public void setPreviousInAccessOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    @GuardedBy(value="evictionLock")
    public Node<K, V> getNextInAccessOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    public void setNextInAccessOrder(@Nullable Node<K, V> next) {
        throw new UnsupportedOperationException();
    }

    public long getWriteTime() {
        return 0L;
    }

    public void setWriteTime(long time) {
    }

    public boolean casWriteTime(long expect, long update) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    @GuardedBy(value="evictionLock")
    public Node<K, V> getPreviousInWriteOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    public void setPreviousInWriteOrder(@Nullable Node<K, V> prev) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    @GuardedBy(value="evictionLock")
    public Node<K, V> getNextInWriteOrder() {
        return null;
    }

    @Override
    @GuardedBy(value="evictionLock")
    public void setNextInWriteOrder(@Nullable Node<K, V> next) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        return String.format("%s=[key=%s, value=%s, weight=%d, queueType=%,d, accessTimeNS=%,d, writeTimeNS=%,d, varTimeNs=%,d, prevInAccess=%s, nextInAccess=%s, prevInWrite=%s, nextInWrite=%s]", this.getClass().getSimpleName(), this.getKey(), this.getValue(), this.getWeight(), this.getQueueType(), this.getAccessTime(), this.getWriteTime(), this.getVariableTime(), this.getPreviousInAccessOrder() != null, this.getNextInAccessOrder() != null, this.getPreviousInWriteOrder() != null, this.getNextInWriteOrder() != null);
    }
}

