/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.profiles.plugin.external.caffeine.cache;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.BoundedWeigher;
import me.lucko.helper.profiles.plugin.external.caffeine.cache.SingletonWeigher;

@FunctionalInterface
@ThreadSafe
public interface Weigher<K, V> {
    @Nonnegative
    public int weigh(@Nonnull K var1, @Nonnull V var2);

    @Nonnull
    public static <K, V> Weigher<K, V> singletonWeigher() {
        SingletonWeigher self = SingletonWeigher.INSTANCE;
        return self;
    }

    @Nonnull
    public static <K, V> Weigher<K, V> boundedWeigher(@Nonnull Weigher<K, V> delegate) {
        return new BoundedWeigher<K, V>(delegate);
    }
}

