/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.bucket.partitioning;

import java.util.concurrent.ThreadLocalRandom;
import me.lucko.helper.bucket.Bucket;
import me.lucko.helper.bucket.BucketPartition;
import me.lucko.helper.bucket.partitioning.GenericPartitioningStrategy;
import me.lucko.helper.bucket.partitioning.PartitioningStrategy;

public final class PartitioningStrategies {
    public static <T> PartitioningStrategy<T> random() {
        return Strategies.RANDOM.cast();
    }

    public static <T> PartitioningStrategy<T> lowestSize() {
        return Strategies.LOWEST_SIZE.cast();
    }

    public static <T> PartitioningStrategy<T> nextInCycle() {
        return Strategies.NEXT_IN_CYCLE.cast();
    }

    public static <T> PartitioningStrategy<T> previousInCycle() {
        return Strategies.PREVIOUS_IN_CYCLE.cast();
    }

    private PartitioningStrategies() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    private static enum Strategies implements GenericPartitioningStrategy
    {
        RANDOM{

            @Override
            public int allocate(Bucket<?> bucket) {
                return ThreadLocalRandom.current().nextInt(bucket.getPartitionCount());
            }
        }
        ,
        LOWEST_SIZE{

            @Override
            public int allocate(Bucket<?> bucket) {
                int index = -1;
                int lowestSize = Integer.MAX_VALUE;
                for (BucketPartition<?> partition : bucket.getPartitions()) {
                    int size = partition.size();
                    int i = partition.getPartitionIndex();
                    if (size == 0) {
                        return i;
                    }
                    if (size >= lowestSize) continue;
                    lowestSize = size;
                    index = i;
                }
                if (index == -1) {
                    throw new AssertionError();
                }
                return index;
            }
        }
        ,
        NEXT_IN_CYCLE{

            @Override
            public int allocate(Bucket<?> bucket) {
                return bucket.asCycle().next().getPartitionIndex();
            }
        }
        ,
        PREVIOUS_IN_CYCLE{

            @Override
            public int allocate(Bucket<?> bucket) {
                return bucket.asCycle().previous().getPartitionIndex();
            }
        };

    }
}

