/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import com.google.inject.Injector;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.lucko.helper.config.objectmapping.GuiceObjectMapper;
import me.lucko.helper.config.objectmapping.ObjectMapper;
import me.lucko.helper.config.objectmapping.ObjectMapperFactory;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public final class GuiceObjectMapperFactory
implements ObjectMapperFactory {
    private final LoadingCache<TypeToken<?>, ObjectMapper<?>> cache = CacheBuilder.newBuilder().weakKeys().maximumSize(512L).build(new CacheLoader<TypeToken<?>, ObjectMapper<?>>(){

        public ObjectMapper<?> load(TypeToken<?> key) throws Exception {
            return new GuiceObjectMapper(GuiceObjectMapperFactory.this.injector, key);
        }
    });
    private final Injector injector;

    @Inject
    protected GuiceObjectMapperFactory(Injector baseInjector) {
        this.injector = baseInjector;
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull Class<T> type) throws ObjectMappingException {
        return this.getMapper(TypeToken.of(type));
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull TypeToken<T> type) throws ObjectMappingException {
        Objects.requireNonNull(type, "type");
        try {
            return (ObjectMapper)this.cache.get(type);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "GuiceObjectMapperFactory{}";
    }
}

