/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.event.functional.single;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.lucko.helper.event.SingleSubscription;
import me.lucko.helper.event.functional.ExpiryTestStage;
import me.lucko.helper.event.functional.single.SingleHandlerList;
import me.lucko.helper.event.functional.single.SingleHandlerListImpl;
import me.lucko.helper.event.functional.single.SingleSubscriptionBuilder;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;

class SingleSubscriptionBuilderImpl<T extends Event>
implements SingleSubscriptionBuilder<T> {
    final Class<T> eventClass;
    final EventPriority priority;
    BiConsumer<? super T, Throwable> exceptionConsumer = DEFAULT_EXCEPTION_CONSUMER;
    boolean handleSubclasses = false;
    final List<Predicate<T>> filters = new ArrayList<Predicate<T>>(3);
    final List<BiPredicate<SingleSubscription<T>, T>> preExpiryTests = new ArrayList<BiPredicate<SingleSubscription<T>, T>>(0);
    final List<BiPredicate<SingleSubscription<T>, T>> midExpiryTests = new ArrayList<BiPredicate<SingleSubscription<T>, T>>(0);
    final List<BiPredicate<SingleSubscription<T>, T>> postExpiryTests = new ArrayList<BiPredicate<SingleSubscription<T>, T>>(0);

    SingleSubscriptionBuilderImpl(Class<T> eventClass, EventPriority priority) {
        this.eventClass = eventClass;
        this.priority = priority;
    }

    @Override
    @Nonnull
    public SingleSubscriptionBuilder<T> expireIf(@Nonnull BiPredicate<SingleSubscription<T>, T> predicate, ExpiryTestStage ... testPoints) {
        Objects.requireNonNull(testPoints, "testPoints");
        Objects.requireNonNull(predicate, "predicate");
        block5: for (ExpiryTestStage testPoint : testPoints) {
            switch (testPoint) {
                case PRE: {
                    this.preExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_FILTER: {
                    this.midExpiryTests.add(predicate);
                    continue block5;
                }
                case POST_HANDLE: {
                    this.postExpiryTests.add(predicate);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ExpiryTestPoint: " + (Object)((Object)testPoint));
                }
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public SingleSubscriptionBuilder<T> filter(@Nonnull Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        this.filters.add(predicate);
        return this;
    }

    @Override
    @Nonnull
    public SingleSubscriptionBuilder<T> exceptionConsumer(@Nonnull BiConsumer<? super T, Throwable> exceptionConsumer) {
        Objects.requireNonNull(exceptionConsumer, "exceptionConsumer");
        this.exceptionConsumer = exceptionConsumer;
        return this;
    }

    @Override
    @Nonnull
    public SingleSubscriptionBuilder<T> handleSubclasses() {
        this.handleSubclasses = true;
        return this;
    }

    @Override
    @Nonnull
    public SingleHandlerList<T> handlers() {
        return new SingleHandlerListImpl(this);
    }
}

