/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.hologram.individual;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;

public interface HologramLine {
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static HologramLine fixed(@Nonnull String text) {
        return viewer -> text;
    }

    @Nonnull
    public static HologramLine fromFunction(@Nonnull Function<Player, String> function) {
        return function::apply;
    }

    @Nonnull
    public String resolve(Player var1);

    public static final class Builder {
        private final ImmutableList.Builder<HologramLine> lines = ImmutableList.builder();

        private Builder() {
        }

        public Builder line(HologramLine line) {
            this.lines.add((Object)line);
            return this;
        }

        public Builder lines(Iterable<? extends HologramLine> lines) {
            this.lines.addAll(lines);
            return this;
        }

        public Builder line(String line) {
            return this.line(HologramLine.fixed(line));
        }

        public Builder fromFunction(@Nonnull Function<Player, String> function) {
            return this.line(HologramLine.fromFunction(function));
        }

        public List<HologramLine> build() {
            return this.lines.build();
        }
    }
}

