/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.internal.exception;

import java.util.concurrent.atomic.AtomicBoolean;
import me.lucko.helper.Events;
import me.lucko.helper.interfaces.Delegate;
import me.lucko.helper.internal.exception.InternalException;
import me.lucko.helper.internal.exception.events.HelperExceptionEvent;
import me.lucko.helper.internal.exception.types.EventHandlerException;
import me.lucko.helper.internal.exception.types.PromiseChainException;
import me.lucko.helper.internal.exception.types.SchedulerTaskException;
import me.lucko.helper.utils.Log;

public final class HelperExceptions {
    private static final ThreadLocal<AtomicBoolean> NOT_TODAY_STACK_OVERFLOW_EXCEPTION = ThreadLocal.withInitial(() -> new AtomicBoolean(false));

    private HelperExceptions() {
    }

    private static void log(InternalException exception) {
        Log.severe(exception.getMessage(), exception);
        AtomicBoolean firing = NOT_TODAY_STACK_OVERFLOW_EXCEPTION.get();
        if (firing.compareAndSet(false, true)) {
            try {
                Events.call(new HelperExceptionEvent(exception));
            }
            finally {
                firing.set(false);
            }
        }
    }

    public static void reportScheduler(Throwable throwable) {
        HelperExceptions.log(new SchedulerTaskException(throwable));
    }

    public static void reportPromise(Throwable throwable) {
        HelperExceptions.log(new PromiseChainException(throwable));
    }

    public static void reportEvent(Object event, Throwable throwable) {
        HelperExceptions.log(new EventHandlerException(throwable, event));
    }

    public static Runnable wrapSchedulerTask(Runnable runnable) {
        return new SchedulerWrappedRunnable(runnable);
    }

    private static final class SchedulerWrappedRunnable
    implements Runnable,
    Delegate<Runnable> {
        private final Runnable delegate;

        private SchedulerWrappedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Throwable t) {
                HelperExceptions.reportScheduler(t);
            }
        }

        @Override
        public Runnable getDelegate() {
            return this.delegate;
        }
    }
}

