/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.scheme;

import com.google.common.collect.Range;
import java.util.Objects;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.scheme.SchemeMapping;

public final class FunctionalSchemeMapping
implements SchemeMapping {
    private final IntFunction<Item> function;
    private final Range<Integer> validRange;

    @Nonnull
    public static SchemeMapping of(@Nonnull IntFunction<Item> function, @Nonnull Range<Integer> validRange) {
        return new FunctionalSchemeMapping(function, validRange);
    }

    private FunctionalSchemeMapping(@Nonnull IntFunction<Item> function, @Nonnull Range<Integer> validRange) {
        this.function = Objects.requireNonNull(function, "function");
        this.validRange = Objects.requireNonNull(validRange, "validRange");
    }

    @Override
    @Nullable
    public Item getNullable(int key) {
        if (!this.hasMappingFor(key)) {
            return null;
        }
        return this.function.apply(key);
    }

    @Override
    public boolean hasMappingFor(int key) {
        return this.validRange.contains((Comparable)Integer.valueOf(key));
    }

    @Override
    @Nonnull
    public SchemeMapping copy() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionalSchemeMapping that = (FunctionalSchemeMapping)o;
        return this.function.equals(that.function) && this.validRange.equals(that.validRange);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.validRange);
    }
}

