/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging.http;

import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.lucko.helper.Schedulers;
import me.lucko.helper.messaging.AbstractMessenger;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.messaging.Messenger;

public class HttpMessenger
implements Messenger {
    private final AbstractMessenger messenger = new AbstractMessenger(this::handleOutgoing, this::subscribe, this::unsubscribe);
    private final HttpServer httpServer;
    private final Function<String, URL> remoteUrl;

    public HttpMessenger(String host, int port, String remoteHost, int remotePort) {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(host, port), 0);
            this.httpServer.setExecutor(Schedulers.async());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remoteUrl = channel -> {
            try {
                return new URL("http", remoteHost, remotePort, (String)channel);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private void handleOutgoing(String channel, byte[] message) {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.remoteUrl.apply(HttpMessenger.encodeChannel(channel)).openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(false);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.connect();
            try (OutputStream out = connection.getOutputStream();){
                out.write(message);
            }
            if (connection.getResponseCode() >= 400) {
                throw new IOException("Response code: " + connection.getResponseCode() + " - " + connection.getResponseMessage());
            }
            connection.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void subscribe(String channel) {
        this.httpServer.createContext(HttpMessenger.encodeChannel(channel), new Handler(channel));
    }

    private void unsubscribe(String channel) {
        this.httpServer.removeContext(HttpMessenger.encodeChannel(channel));
    }

    private static String encodeChannel(String channel) {
        try {
            return '/' + URLEncoder.encode(channel, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull TypeToken<T> type) {
        return this.messenger.getChannel(name, type);
    }

    private final class Handler
    implements HttpHandler {
        private final String channelName;

        private Handler(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            byte[] message;
            String method = exchange.getRequestMethod();
            if (!method.equals("POST")) {
                throw new UnsupportedEncodingException("Unsupported request: " + exchange.getRequestMethod());
            }
            try (InputStream in = exchange.getRequestBody();){
                message = ByteStreams.toByteArray((InputStream)in);
            }
            HttpMessenger.this.messenger.registerIncomingMessage(this.channelName, message);
            exchange.sendResponseHeaders(200, 0L);
            exchange.getResponseBody().close();
        }
    }
}

