/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.reflect;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.reflect.MinecraftVersions;
import me.lucko.helper.reflect.SnapshotVersion;

public final class MinecraftVersion
implements Comparable<MinecraftVersion> {
    public static final Comparator<MinecraftVersion> COMPARATOR = Comparator.nullsFirst(Comparator.comparingInt(MinecraftVersion::getMajor).thenComparingInt(MinecraftVersion::getMinor).thenComparingInt(MinecraftVersion::getBuild).thenComparing(Comparator.nullsLast(Comparator.comparing(MinecraftVersion::getDevelopmentStage))).thenComparing(Comparator.nullsFirst(Comparator.comparing(MinecraftVersion::getSnapshot))));
    private static final String NEWEST_MINECRAFT_VERSION = "1.19.2";
    private static final String MINECRAFT_LAST_RELEASE_DATE = "2022-08-05";
    private final int major;
    private final int minor;
    private final int build;
    @Nullable
    private final String development;
    @Nullable
    private final SnapshotVersion snapshot;

    public static MinecraftVersion getRuntimeVersion() {
        return MinecraftVersions.RUNTIME_VERSION;
    }

    public static MinecraftVersion of(int major, int minor, int build) {
        return new MinecraftVersion(major, minor, build, null, null);
    }

    public static MinecraftVersion parse(String version) throws IllegalArgumentException {
        return MinecraftVersion.parse(version, true);
    }

    public static MinecraftVersion parse(String version, boolean parseSnapshot) throws IllegalArgumentException {
        String[] parts = version.split("-");
        SnapshotVersion snapshot = null;
        int[] versionComponents = new int[3];
        try {
            versionComponents = MinecraftVersion.parseVersion(parts[0]);
        }
        catch (NumberFormatException cause) {
            if (!parseSnapshot) {
                throw cause;
            }
            try {
                snapshot = SnapshotVersion.parse(parts[0]);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                MinecraftVersion latest = MinecraftVersion.parse(NEWEST_MINECRAFT_VERSION, false);
                boolean newer = snapshot.getSnapshotDate().compareTo(format.parse(MINECRAFT_LAST_RELEASE_DATE)) > 0;
                versionComponents[0] = latest.getMajor();
                versionComponents[1] = latest.getMinor() + (newer ? 1 : -1);
                versionComponents[2] = 0;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot parse " + parts[0], e);
            }
        }
        int major = versionComponents[0];
        int minor = versionComponents[1];
        int build = versionComponents[2];
        String development = parts.length > 1 ? parts[1] : (snapshot != null ? "snapshot" : null);
        return new MinecraftVersion(major, minor, build, development, snapshot);
    }

    private static int[] parseVersion(String version) {
        String[] elements = version.split("\\.");
        int[] numbers = new int[3];
        if (elements.length < 1) {
            throw new IllegalStateException("Corrupt MC version: " + version);
        }
        for (int i = 0; i < Math.min(numbers.length, elements.length); ++i) {
            numbers[i] = Integer.parseInt(elements[i].trim());
        }
        return numbers;
    }

    private MinecraftVersion(int major, int minor, int build, @Nullable String development, @Nullable SnapshotVersion snapshot) {
        this.major = major;
        this.minor = minor;
        this.build = build;
        this.development = development;
        this.snapshot = snapshot;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getBuild() {
        return this.build;
    }

    @Nullable
    public String getDevelopmentStage() {
        return this.development;
    }

    @Nullable
    public SnapshotVersion getSnapshot() {
        return this.snapshot;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    @Nonnull
    public String getVersion() {
        if (this.getDevelopmentStage() == null) {
            return String.format("%s.%s.%s", this.getMajor(), this.getMinor(), this.getBuild());
        }
        return String.format("%s.%s.%s-%s%s", this.getMajor(), this.getMinor(), this.getBuild(), this.getDevelopmentStage(), this.isSnapshot() ? this.snapshot : "");
    }

    @Override
    public int compareTo(MinecraftVersion that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean isAfter(MinecraftVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isAfterOrEq(MinecraftVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isBefore(MinecraftVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isBeforeOrEq(MinecraftVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isBetween(MinecraftVersion o1, MinecraftVersion o2) {
        return this.isAfterOrEq(o1) && this.isBeforeOrEq(o2) || this.isBeforeOrEq(o1) && this.isAfterOrEq(o2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MinecraftVersion)) {
            return false;
        }
        MinecraftVersion other = (MinecraftVersion)obj;
        return this.getMajor() == other.getMajor() && this.getMinor() == other.getMinor() && this.getBuild() == other.getBuild() && Objects.equals(this.getDevelopmentStage(), other.getDevelopmentStage());
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getBuild());
    }

    public String toString() {
        return String.format("(MC: %s)", this.getVersion());
    }
}

