/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.reflect;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.reflect.MinecraftVersion;
import me.lucko.helper.utils.Indexing;

public enum NmsVersion {
    NONE(new MinecraftVersion[0]){

        @Override
        protected String getPackageComponent() {
            return ".";
        }
    }
    ,
    v1_8_R1(MinecraftVersion.of(1, 8, 0)),
    v1_8_R2(MinecraftVersion.of(1, 8, 3)),
    v1_8_R3(MinecraftVersion.of(1, 8, 4), MinecraftVersion.of(1, 8, 5), MinecraftVersion.of(1, 8, 6), MinecraftVersion.of(1, 8, 7), MinecraftVersion.of(1, 8, 8)),
    v1_9_R1(MinecraftVersion.of(1, 9, 0), MinecraftVersion.of(1, 9, 2)),
    v1_9_R2(MinecraftVersion.of(1, 9, 4)),
    v1_10_R1(MinecraftVersion.of(1, 10, 0), MinecraftVersion.of(1, 10, 2)),
    v1_11_R1(MinecraftVersion.of(1, 11, 0), MinecraftVersion.of(1, 11, 1), MinecraftVersion.of(1, 11, 2)),
    v1_12_R1(MinecraftVersion.of(1, 12, 0), MinecraftVersion.of(1, 12, 1), MinecraftVersion.of(1, 12, 2)),
    v1_13_R1(MinecraftVersion.of(1, 13, 0)),
    v1_13_R2(MinecraftVersion.of(1, 13, 1), MinecraftVersion.of(1, 13, 2)),
    v1_14_R1(MinecraftVersion.of(1, 14, 0), MinecraftVersion.of(1, 14, 1), MinecraftVersion.of(1, 14, 2), MinecraftVersion.of(1, 14, 3), MinecraftVersion.of(1, 14, 4)),
    v1_15_R1(MinecraftVersion.of(1, 15, 0), MinecraftVersion.of(1, 15, 1), MinecraftVersion.of(1, 15, 2)),
    v1_16_R1(MinecraftVersion.of(1, 16, 0), MinecraftVersion.of(1, 16, 1)),
    v1_16_R2(MinecraftVersion.of(1, 16, 2), MinecraftVersion.of(1, 16, 3)),
    v1_16_R3(MinecraftVersion.of(1, 16, 4), MinecraftVersion.of(1, 16, 5)),
    v1_17_R1(MinecraftVersion.of(1, 17, 0), MinecraftVersion.of(1, 17, 1)),
    v1_18_R1(MinecraftVersion.of(1, 18, 0), MinecraftVersion.of(1, 18, 1), MinecraftVersion.of(1, 18, 2)),
    v1_19_R1(MinecraftVersion.of(1, 19, 0), MinecraftVersion.of(1, 19, 1), MinecraftVersion.of(1, 19, 2));

    private final Set<MinecraftVersion> minecraftVersions;
    private final String nmsPrefix;
    private final String obcPrefix;
    private static final Map<MinecraftVersion, NmsVersion> MC_TO_NMS;

    private NmsVersion(MinecraftVersion ... minecraftVersions) {
        this.minecraftVersions = ImmutableSet.copyOf((Object[])minecraftVersions);
        this.nmsPrefix = "net.minecraft.server" + this.getPackageComponent();
        this.obcPrefix = "org.bukkit.craftbukkit" + this.getPackageComponent();
    }

    protected String getPackageComponent() {
        return "." + this.name() + ".";
    }

    public Set<MinecraftVersion> getMinecraftVersions() {
        return this.minecraftVersions;
    }

    @Nonnull
    public String nms(String className) {
        return this.nmsPrefix + className;
    }

    @Nonnull
    public Class<?> nmsClass(String className) throws ClassNotFoundException {
        return Class.forName(this.nms(className));
    }

    @Nonnull
    public String obc(String className) {
        return this.obcPrefix + className;
    }

    @Nonnull
    public Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(this.obc(className));
    }

    @Nullable
    public static NmsVersion forMinecraftVersion(MinecraftVersion minecraftVersion) {
        return MC_TO_NMS.get(minecraftVersion);
    }

    static {
        MC_TO_NMS = Indexing.buildMultiple(NmsVersion.values(), NmsVersion::getMinecraftVersions);
    }
}

