/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.terminable;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.terminable.TerminableConsumer;

@FunctionalInterface
public interface Terminable
extends AutoCloseable {
    public static final Terminable EMPTY = () -> {};

    @Override
    public void close() throws Exception;

    default public boolean isClosed() {
        return false;
    }

    @Nullable
    default public Exception closeSilently() {
        try {
            this.close();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    default public void closeAndReportException() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    default public void bindWith(@Nonnull TerminableConsumer consumer) {
        consumer.bind(this);
    }
}

