/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.text.event;

import com.google.common.base.Enums;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ClickEvent {
    private final @NonNull Action action;
    private final @NonNull String value;

    public ClickEvent(@NonNull Action action, @NonNull String value) {
        this.action = action;
        this.value = value;
    }

    public @NonNull Action action() {
        return this.action;
    }

    public @NonNull String value() {
        return this.value;
    }

    public @NonNull ClickEvent copy() {
        return new ClickEvent(this.action, this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClickEvent that = (ClickEvent)other;
        return this.action == that.action && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.action, this.value});
    }

    public @NonNull String toString() {
        return Objects.toStringHelper((Object)this).add("action", (Object)this.action).add("value", (Object)this.value).toString();
    }

    public static enum Action {
        OPEN_URL(true),
        OPEN_FILE(false),
        RUN_COMMAND(true),
        SUGGEST_COMMAND(true),
        CHANGE_PAGE(true);

        private final @NonNull String toString = Enums.getField((Enum)this).getAnnotation(SerializedName.class).value();
        private final boolean readable;

        private Action(boolean readable) {
            this.readable = readable;
        }

        public boolean readable() {
            return this.readable;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public @NonNull String toString() {
            return this.toString;
        }
    }
}

