/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class Indexing {
    private Indexing() {
    }

    public static <I, R> Map<I, R> build(Iterable<? extends R> values, Function<? super R, ? extends I> indexFunction) {
        Objects.requireNonNull(indexFunction, "indexFunction");
        return Indexing.buildMultiple(values, (? super R r) -> Collections.singleton(indexFunction.apply((Object)r)));
    }

    public static <I, R> Map<I, R> buildMultiple(Iterable<? extends R> values, Function<? super R, ? extends Iterable<? extends I>> indexFunction) {
        Objects.requireNonNull(values, "values");
        Objects.requireNonNull(indexFunction, "indexFunction");
        HashMap<I, R> map = new HashMap<I, R>();
        for (R value : values) {
            Iterable<I> indexes = indexFunction.apply(value);
            for (I index : indexes) {
                R prev = map.put(index, value);
                if (prev == null) continue;
                throw new IllegalStateException("An index for " + value + " (" + index + ") was already associated with " + prev);
            }
        }
        return ImmutableMap.copyOf(map);
    }

    public static <I, R> Map<I, R> build(R[] values, Function<? super R, ? extends I> indexFunction) {
        Objects.requireNonNull(values, "values");
        return Indexing.build(Arrays.asList(values), indexFunction);
    }

    public static <I, R> Map<I, R> buildMultiple(R[] values, Function<? super R, ? extends Iterable<? extends I>> indexFunction) {
        Objects.requireNonNull(values, "values");
        return Indexing.buildMultiple(Arrays.asList(values), indexFunction);
    }

    public static <R extends Enum<?>> Map<String, R> buildFromEnumName(Class<? extends R> enumClass) {
        Objects.requireNonNull(enumClass, "enumClass");
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Type is not an enum: " + enumClass);
        }
        return Indexing.build(enumConstants, Enum::name);
    }
}

