/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.util.function.Predicate;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.InvalidTypeException;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class NumberSerializer
implements TypeSerializer<Number> {
    NumberSerializer() {
    }

    public static Predicate<TypeToken<Number>> getPredicate() {
        return type -> {
            Class clazz = (type = type.wrap()).getRawType();
            return Integer.class.equals((Object)clazz) || Long.class.equals((Object)clazz) || Short.class.equals((Object)clazz) || Byte.class.equals((Object)clazz) || Float.class.equals((Object)clazz) || Double.class.equals((Object)clazz);
        };
    }

    @Override
    public Number deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws InvalidTypeException {
        Class clazz = (type = type.wrap()).getRawType();
        if (Integer.class.equals((Object)clazz)) {
            return value.getInt();
        }
        if (Long.class.equals((Object)clazz)) {
            return value.getLong();
        }
        if (Short.class.equals((Object)clazz)) {
            return (short)value.getInt();
        }
        if (Byte.class.equals((Object)clazz)) {
            return (byte)value.getInt();
        }
        if (Float.class.equals((Object)clazz)) {
            return Float.valueOf(value.getFloat());
        }
        if (Double.class.equals((Object)clazz)) {
            return value.getDouble();
        }
        return null;
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable Number obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (obj == null) {
            value.setValue(null);
            return;
        }
        if (value.getOptions().acceptsType(obj.getClass())) {
            value.setValue(obj);
            return;
        }
        if (obj instanceof Float && value.getOptions().acceptsType(Double.class)) {
            value.setValue(obj.doubleValue());
        } else if (obj instanceof Byte) {
            if (value.getOptions().acceptsType(Short.class)) {
                value.setValue(obj.shortValue());
            } else if (value.getOptions().acceptsType(Integer.class)) {
                value.setValue(obj.intValue());
            } else if (value.getOptions().acceptsType(Long.class)) {
                value.setValue(obj.longValue());
            }
        } else if (obj instanceof Short) {
            if (value.getOptions().acceptsType(Integer.class)) {
                value.setValue(obj.intValue());
            } else if (value.getOptions().acceptsType(Long.class)) {
                value.setValue(obj.longValue());
            }
        } else if (obj instanceof Integer) {
            if (value.getOptions().acceptsType(Long.class)) {
                value.setValue(obj.longValue());
            }
        } else {
            throw new ObjectMappingException("Unable to coerce value of type " + obj.getClass() + " to one accepted by node " + value);
        }
    }
}

