/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class PatternSerializer
implements TypeSerializer<Pattern> {
    PatternSerializer() {
    }

    @Override
    public Pattern deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        try {
            return Pattern.compile(value.getString());
        }
        catch (PatternSyntaxException ex) {
            throw new ObjectMappingException(ex);
        }
    }

    @Override
    public void serialize(@NonNull TypeToken<?> type, @Nullable Pattern obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        value.setValue(obj.pattern());
    }
}

