/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.function.Predicate;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ScalarSerializer<T>
implements TypeSerializer<T> {
    private final TypeToken<T> type;

    protected ScalarSerializer(TypeToken<T> type) {
        this.type = type.wrap();
    }

    protected ScalarSerializer(Class<T> type) {
        if (type.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Provided type " + type + " has type parameters but was not provided as a TypeToken!");
        }
        this.type = TypeToken.of(type);
    }

    public final TypeToken<T> type() {
        return this.type;
    }

    @Override
    public final @Nullable T deserialize(TypeToken<?> type, ConfigurationNode node) throws ObjectMappingException {
        List<? extends ConfigurationNode> children;
        ConfigurationNode deserializeFrom = node;
        if (node.isList() && (children = node.getChildrenList()).size() == 1) {
            deserializeFrom = children.get(0);
        }
        if (deserializeFrom.isList() || deserializeFrom.isMap()) {
            throw new ObjectMappingException("Value must be provided as a scalar!");
        }
        @Nullable Object value = deserializeFrom.getValue();
        if (value == null) {
            return null;
        }
        type = type.wrap();
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(type, value);
    }

    @Override
    public final void serialize(TypeToken<?> type, @Nullable T obj, ConfigurationNode node) {
        if (obj == null) {
            node.setValue(null);
            return;
        }
        if (node.getOptions().acceptsType(obj.getClass())) {
            node.setValue(obj);
            return;
        }
        node.setValue(this.serialize(obj, node.getOptions()::acceptsType));
    }

    public abstract T deserialize(TypeToken<?> var1, Object var2) throws ObjectMappingException;

    public abstract Object serialize(T var1, Predicate<Class<?>> var2);

    public final T deserialize(Object value) throws ObjectMappingException {
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(this.type(), value);
    }

    private @Nullable T cast(Object value) {
        Class rawType = this.type().getRawType();
        if (rawType.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public final @Nullable T tryDeserialize(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.deserialize(obj);
        }
        catch (ObjectMappingException ex) {
            return null;
        }
    }

    public final String serializeToString(T item) {
        if (item instanceof CharSequence) {
            return item.toString();
        }
        return (String)this.serialize(item, clazz -> clazz.isAssignableFrom(String.class));
    }
}

