/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.objectmapping.serialize;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import me.lucko.helper.config.objectmapping.serialize.RegisteredSerializer;
import me.lucko.helper.config.objectmapping.serialize.ScalarSerializer;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializers;

public class TypeSerializerCollection {
    private final TypeSerializerCollection parent;
    private final SerializerList serializers = new SerializerList();
    private final Map<TypeToken<?>, TypeSerializer<?>> typeMatches = new ConcurrentHashMap();

    TypeSerializerCollection(TypeSerializerCollection parent) {
        this.parent = parent;
    }

    public static TypeSerializerCollection defaults() {
        return TypeSerializers.DEFAULT_SERIALIZERS;
    }

    public static TypeSerializerCollection create() {
        return TypeSerializerCollection.defaults().newChild();
    }

    public <T> TypeSerializer<T> get(TypeToken<T> type) {
        TypeSerializer<Object> serial = this.typeMatches.computeIfAbsent(type = Objects.requireNonNull(type).wrap(), this.serializers);
        if (serial == null && this.parent != null) {
            serial = this.parent.get(type);
        }
        return serial;
    }

    @Deprecated
    public <T> TypeSerializerCollection registerType(TypeToken<T> type, TypeSerializer<? super T> serializer) {
        return this.register(type, serializer);
    }

    public <T> TypeSerializerCollection register(TypeToken<T> type, TypeSerializer<? super T> serializer) {
        this.serializers.add(new RegisteredSerializer(Objects.requireNonNull(type, "type"), Objects.requireNonNull(serializer)));
        this.typeMatches.clear();
        return this;
    }

    @Deprecated
    public <T> TypeSerializerCollection registerPredicate(Predicate<TypeToken<T>> test, TypeSerializer<? super T> serializer) {
        return this.register(test, serializer);
    }

    public <T> TypeSerializerCollection register(Predicate<TypeToken<T>> test, TypeSerializer<? super T> serializer) {
        this.serializers.add(new RegisteredSerializer(Objects.requireNonNull(test, "test"), Objects.requireNonNull(serializer, "serializer")));
        this.typeMatches.clear();
        return this;
    }

    public <T> TypeSerializerCollection register(ScalarSerializer<T> serializer) {
        return this.register(serializer.type(), serializer);
    }

    public TypeSerializerCollection newChild() {
        return new TypeSerializerCollection(this);
    }

    private static final class SerializerList
    extends CopyOnWriteArrayList<RegisteredSerializer>
    implements Function<TypeToken<?>, TypeSerializer<?>> {
        private SerializerList() {
        }

        @Override
        public TypeSerializer<?> apply(TypeToken<?> type) {
            for (RegisteredSerializer ent : this) {
                if (!ent.predicate.test(type)) continue;
                return ent.serializer;
            }
            return null;
        }
    }
}

