/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.reference;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.function.Function;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import me.lucko.helper.config.reactive.Disposable;
import me.lucko.helper.config.reactive.Publisher;
import me.lucko.helper.config.reactive.Subscriber;
import me.lucko.helper.config.reactive.TransactionFailedException;
import me.lucko.helper.config.reference.ConfigurationReference;
import me.lucko.helper.config.reference.ManualConfigurationReference;
import me.lucko.helper.config.reference.ValueReference;
import org.checkerframework.checker.nullness.qual.Nullable;

class ValueReferenceImpl<@Nullable T>
implements ValueReference<T>,
Publisher<T> {
    private final ManualConfigurationReference<?> root;
    private final Object[] path;
    private final TypeToken<T> type;
    private final TypeSerializer<T> serializer;
    private final Publisher.Cached<T> deserialized;

    ValueReferenceImpl(ManualConfigurationReference<?> root, Object[] path, TypeToken<T> type, @Nullable T def) throws ObjectMappingException {
        this.root = root;
        this.path = Arrays.copyOf(path, path.length);
        this.type = type;
        this.serializer = root.getNode().getOptions().getSerializers().get(type);
        if (this.serializer == null) {
            throw new ObjectMappingException("Unsupported type" + type);
        }
        this.deserialized = root.updateListener.map((I n) -> {
            try {
                return this.deserializedValueFrom((ConfigurationNode)n, def);
            }
            catch (ObjectMappingException e) {
                root.errorListener.submit(Maps.immutableEntry((Object)((Object)ConfigurationReference.ErrorPhase.VALUE), (Object)e));
                throw new TransactionFailedException(e);
            }
        }).cache(this.deserializedValueFrom((ConfigurationNode)root.getNode(), def));
    }

    ValueReferenceImpl(ManualConfigurationReference<?> root, Object[] path, Class<T> type, @Nullable T def) throws ObjectMappingException {
        this(root, path, TypeToken.of(type), def);
    }

    private @Nullable T deserializedValueFrom(ConfigurationNode parent, @Nullable T defaultVal) throws ObjectMappingException {
        ConfigurationNode node = parent.getNode(this.path);
        @Nullable T possible = this.serializer.deserialize(this.type, node);
        if (possible != null) {
            return possible;
        }
        if (defaultVal != null && node.getOptions().shouldCopyDefaults()) {
            this.serializer.serialize(this.type, defaultVal, node);
        }
        return defaultVal;
    }

    @Override
    public @Nullable T get() {
        return this.deserialized.get();
    }

    @Override
    public boolean set(@Nullable T value) {
        try {
            this.serializer.serialize(this.type, value, this.getNode());
            this.deserialized.submit(value);
            return true;
        }
        catch (ObjectMappingException e) {
            this.root.errorListener.submit(Maps.immutableEntry((Object)((Object)ConfigurationReference.ErrorPhase.SAVING), (Object)e));
            return false;
        }
    }

    @Override
    public boolean setAndSave(@Nullable T value) {
        try {
            if (this.set(value)) {
                this.root.save();
                return true;
            }
        }
        catch (IOException e) {
            this.root.errorListener.submit(Maps.immutableEntry((Object)((Object)ConfigurationReference.ErrorPhase.SAVING), (Object)e));
        }
        return false;
    }

    @Override
    public Publisher<Boolean> setAndSaveAsync(@Nullable T value) {
        return Publisher.execute(() -> {
            this.serializer.serialize(this.type, value, this.getNode());
            this.deserialized.submit(value);
            this.root.save();
            return true;
        }, this.root.updates().getExecutor());
    }

    @Override
    public boolean update(Function<@Nullable T, ? extends T> action) {
        try {
            return this.set(action.apply(this.get()));
        }
        catch (Throwable t) {
            this.root.errorListener.submit(Maps.immutableEntry((Object)((Object)ConfigurationReference.ErrorPhase.VALUE), (Object)t));
            return false;
        }
    }

    @Override
    public Publisher<Boolean> updateAsync(Function<T, ? extends T> action) {
        return Publisher.execute(() -> {
            @Nullable T orig = this.get();
            Object updated = action.apply(orig);
            this.serializer.serialize(this.type, updated, this.getNode());
            this.deserialized.submit(updated);
            this.root.save();
            return true;
        }, this.root.updates().getExecutor());
    }

    @Override
    public ConfigurationNode getNode() {
        return this.root.getNode().getNode(this.path);
    }

    @Override
    public Disposable subscribe(Subscriber<? super T> subscriber) {
        return this.deserialized.subscribe(subscriber);
    }

    @Override
    public boolean hasSubscribers() {
        return this.deserialized.hasSubscribers();
    }

    @Override
    public Executor getExecutor() {
        return this.deserialized.getExecutor();
    }
}

