/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.reference;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.loader.ConfigurationLoader;
import me.lucko.helper.config.reactive.Disposable;
import me.lucko.helper.config.reactive.Subscriber;
import me.lucko.helper.config.reference.ConfigurationReference;
import me.lucko.helper.config.reference.DirectoryListenerRegistration;
import me.lucko.helper.config.reference.PrefixedNameThreadFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WatchServiceListener
implements AutoCloseable {
    private static final WatchEvent.Kind<?>[] DEFAULT_WATCH_EVENTS = new WatchEvent.Kind[]{StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private static final int PARALLEL_THRESHOLD = 100;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new PrefixedNameThreadFactory("Configurate-WatchService", true);
    private final WatchService watchService;
    private volatile boolean open = true;
    private final Thread executor;
    final Executor taskExecutor;
    private final ConcurrentHashMap<Path, DirectoryListenerRegistration> activeListeners = new ConcurrentHashMap();
    private static final ThreadLocal<IOException> exceptionHolder = new ThreadLocal();

    public static Builder builder() {
        return new Builder();
    }

    public static WatchServiceListener create() throws IOException {
        return new WatchServiceListener(DEFAULT_THREAD_FACTORY, FileSystems.getDefault(), ForkJoinPool.commonPool());
    }

    private WatchServiceListener(ThreadFactory factory, FileSystem fileSystem, Executor taskExecutor) throws IOException {
        this.watchService = fileSystem.newWatchService();
        this.executor = factory.newThread(() -> {
            while (this.open) {
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (InterruptedException | ClosedWatchServiceException e) {
                    break;
                }
                Path watched = (Path)key.watchable();
                DirectoryListenerRegistration registration = this.activeListeners.get(watched);
                if (registration == null) continue;
                HashSet seenContexts = new HashSet();
                for (WatchEvent<?> event : key.pollEvents()) {
                    if (!key.isValid()) break;
                    if (!seenContexts.add(event.context())) continue;
                    registration.submit(event);
                    if (!registration.closeIfEmpty()) continue;
                    key.cancel();
                    break;
                }
                if (key.reset()) continue;
                DirectoryListenerRegistration oldListeners = this.activeListeners.remove(watched);
                oldListeners.onClose();
            }
        });
        this.taskExecutor = taskExecutor;
        this.executor.start();
    }

    private DirectoryListenerRegistration getRegistration(Path directory) throws IOException {
        @Nullable DirectoryListenerRegistration reg = this.activeListeners.computeIfAbsent(directory, dir -> {
            try {
                return new DirectoryListenerRegistration(dir.register(this.watchService, DEFAULT_WATCH_EVENTS), this.taskExecutor);
            }
            catch (IOException ex) {
                exceptionHolder.set(ex);
                return null;
            }
        });
        if (reg == null) {
            throw exceptionHolder.get();
        }
        return reg;
    }

    public Disposable listenToFile(Path file, Subscriber<WatchEvent<?>> callback) throws IOException, IllegalArgumentException {
        if (Files.isDirectory(file = file.toAbsolutePath(), new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + file + " must be a file");
        }
        Path fileName = file.getFileName();
        return this.getRegistration(file.getParent()).subscribe(fileName, callback);
    }

    public Disposable listenToDirectory(Path directory, Subscriber<WatchEvent<?>> callback) throws IOException, IllegalArgumentException {
        if (!Files.isDirectory(directory = directory.toAbsolutePath(), new LinkOption[0]) && Files.exists(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + directory + " must be a directory");
        }
        return this.getRegistration(directory).subscribe(callback);
    }

    public <N extends ConfigurationNode> ConfigurationReference<N> listenToConfiguration(Function<Path, ConfigurationLoader<? extends N>> loaderFunc, Path path) throws IOException {
        return ConfigurationReference.createWatching(loaderFunc, path, this);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        this.watchService.close();
        this.activeListeners.forEachValue(100L, DirectoryListenerRegistration::onClose);
        this.activeListeners.clear();
        try {
            this.executor.join();
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to await termination of executor thread!");
        }
    }

    public static class Builder {
        private @Nullable ThreadFactory threadFactory;
        private @Nullable FileSystem fileSystem;
        private @Nullable Executor taskExecutor;

        private Builder() {
        }

        public Builder setThreadFactory(ThreadFactory factory) {
            this.threadFactory = Objects.requireNonNull(factory, "factory");
            return this;
        }

        public Builder setTaskExecutor(Executor executor) {
            this.taskExecutor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        public Builder setFileSystem(FileSystem system) {
            this.fileSystem = system;
            return this;
        }

        public WatchServiceListener build() throws IOException {
            if (this.threadFactory == null) {
                this.threadFactory = DEFAULT_THREAD_FACTORY;
            }
            if (this.fileSystem == null) {
                this.fileSystem = FileSystems.getDefault();
            }
            if (this.taskExecutor == null) {
                this.taskExecutor = ForkJoinPool.commonPool();
            }
            return new WatchServiceListener(this.threadFactory, this.fileSystem, this.taskExecutor);
        }
    }
}

