/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.config.typeserializers;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import me.lucko.helper.config.ConfigurationNode;
import me.lucko.helper.config.objectmapping.ObjectMappingException;
import me.lucko.helper.config.objectmapping.serialize.TypeSerializer;
import me.lucko.helper.gson.GsonProvider;
import me.lucko.helper.text3.Component;

public class Text3TypeSerializer
implements TypeSerializer<Component> {
    public static final Text3TypeSerializer INSTANCE = new Text3TypeSerializer();

    private Text3TypeSerializer() {
    }

    @Override
    public Component deserialize(TypeToken<?> typeToken, ConfigurationNode node) throws ObjectMappingException {
        JsonElement json = (JsonElement)node.getValue(TypeToken.of(JsonElement.class));
        return (Component)GsonProvider.standard().fromJson(json, typeToken.getType());
    }

    @Override
    public void serialize(TypeToken<?> typeToken, Component component, ConfigurationNode node) throws ObjectMappingException {
        JsonElement element = GsonProvider.standard().toJsonTree((Object)component, typeToken.getType());
        node.setValue(TypeToken.of(JsonElement.class), element);
    }
}

