/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapterFactory;
import java.io.Reader;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.lucko.helper.datatree.DataTree;
import me.lucko.helper.gson.typeadapters.BukkitSerializableAdapterFactory;
import me.lucko.helper.gson.typeadapters.GsonSerializableAdapterFactory;
import me.lucko.helper.gson.typeadapters.JsonElementTreeSerializer;
import me.lucko.helper.text3.serializer.gson.GsonComponentSerializer;

public final class GsonProvider {
    private static final Gson STANDARD_GSON = GsonComponentSerializer.populate(new GsonBuilder()).registerTypeHierarchyAdapter(DataTree.class, (Object)JsonElementTreeSerializer.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)GsonSerializableAdapterFactory.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)BukkitSerializableAdapterFactory.INSTANCE).serializeNulls().disableHtmlEscaping().create();
    private static final Gson PRETTY_PRINT_GSON = GsonComponentSerializer.populate(new GsonBuilder()).registerTypeHierarchyAdapter(DataTree.class, (Object)JsonElementTreeSerializer.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)GsonSerializableAdapterFactory.INSTANCE).registerTypeAdapterFactory((TypeAdapterFactory)BukkitSerializableAdapterFactory.INSTANCE).serializeNulls().disableHtmlEscaping().setPrettyPrinting().create();
    private static final JsonParser PARSER = new JsonParser();

    @Nonnull
    public static Gson standard() {
        return STANDARD_GSON;
    }

    @Nonnull
    public static Gson prettyPrinting() {
        return PRETTY_PRINT_GSON;
    }

    @Nonnull
    public static JsonParser parser() {
        return PARSER;
    }

    @Nonnull
    public static JsonObject readObject(@Nonnull Reader reader) {
        return PARSER.parse(reader).getAsJsonObject();
    }

    @Nonnull
    public static JsonObject readObject(@Nonnull String s) {
        return PARSER.parse(s).getAsJsonObject();
    }

    public static void writeObject(@Nonnull Appendable writer, @Nonnull JsonObject object) {
        GsonProvider.standard().toJson((JsonElement)object, writer);
    }

    public static void writeObjectPretty(@Nonnull Appendable writer, @Nonnull JsonObject object) {
        GsonProvider.prettyPrinting().toJson((JsonElement)object, writer);
    }

    public static void writeElement(@Nonnull Appendable writer, @Nonnull JsonElement element) {
        GsonProvider.standard().toJson(element, writer);
    }

    public static void writeElementPretty(@Nonnull Appendable writer, @Nonnull JsonElement element) {
        GsonProvider.prettyPrinting().toJson(element, writer);
    }

    @Nonnull
    public static String toString(@Nonnull JsonElement element) {
        return Objects.requireNonNull(GsonProvider.standard().toJson(element));
    }

    @Nonnull
    public static String toStringPretty(@Nonnull JsonElement element) {
        return Objects.requireNonNull(GsonProvider.prettyPrinting().toJson(element));
    }

    private GsonProvider() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }

    @Nonnull
    @Deprecated
    public static Gson get() {
        return GsonProvider.standard();
    }

    @Nonnull
    @Deprecated
    public static Gson getPrettyPrinting() {
        return GsonProvider.prettyPrinting();
    }
}

