/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.menu.scheme;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.menu.Item;
import me.lucko.helper.menu.scheme.SchemeMapping;

public class AbstractSchemeMapping
implements SchemeMapping {
    private final Map<Integer, Item> mapping;

    @Nonnull
    public static SchemeMapping of(@Nonnull Map<Integer, Item> mapping) {
        return new AbstractSchemeMapping(mapping);
    }

    private AbstractSchemeMapping(@Nonnull Map<Integer, Item> mapping) {
        Objects.requireNonNull(mapping, "mapping");
        this.mapping = ImmutableMap.copyOf(mapping);
    }

    @Override
    @Nullable
    public Item getNullable(int key) {
        return this.mapping.get(key);
    }

    @Override
    public boolean hasMappingFor(int key) {
        return this.mapping.containsKey(key);
    }

    @Override
    @Nonnull
    public SchemeMapping copy() {
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractSchemeMapping && ((AbstractSchemeMapping)obj).mapping.equals(this.mapping);
    }

    public int hashCode() {
        return this.mapping.hashCode();
    }
}

