/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging;

import com.google.common.reflect.TypeToken;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.messaging.conversation.ConversationChannel;
import me.lucko.helper.messaging.conversation.ConversationMessage;
import me.lucko.helper.messaging.conversation.SimpleConversationChannel;
import me.lucko.helper.messaging.reqresp.ReqRespChannel;
import me.lucko.helper.messaging.reqresp.SimpleReqRespChannel;

public interface Messenger {
    @Nonnull
    public <T> Channel<T> getChannel(@Nonnull String var1, @Nonnull TypeToken<T> var2);

    @Nonnull
    default public <T extends ConversationMessage, R extends ConversationMessage> ConversationChannel<T, R> getConversationChannel(@Nonnull String name, @Nonnull TypeToken<T> type, @Nonnull TypeToken<R> replyType) {
        return new SimpleConversationChannel<T, R>(this, name, type, replyType);
    }

    @Nonnull
    default public <Req, Resp> ReqRespChannel<Req, Resp> getReqRespChannel(@Nonnull String name, @Nonnull TypeToken<Req> reqType, @Nonnull TypeToken<Resp> respType) {
        return new SimpleReqRespChannel<Req, Resp>(this, name, reqType, respType);
    }

    @Nonnull
    default public <T> Channel<T> getChannel(@Nonnull String name, @Nonnull Class<T> clazz) {
        return this.getChannel(name, TypeToken.of(Objects.requireNonNull(clazz)));
    }

    @Nonnull
    default public <T extends ConversationMessage, R extends ConversationMessage> ConversationChannel<T, R> getConversationChannel(@Nonnull String name, @Nonnull Class<T> clazz, @Nonnull Class<R> replyClazz) {
        return this.getConversationChannel(name, TypeToken.of(Objects.requireNonNull(clazz)), TypeToken.of(Objects.requireNonNull(replyClazz)));
    }

    @Nonnull
    default public <Req, Resp> ReqRespChannel<Req, Resp> getReqRespChannel(@Nonnull String name, @Nonnull Class<Req> reqClass, @Nonnull Class<Resp> respClass) {
        return this.getReqRespChannel(name, TypeToken.of(Objects.requireNonNull(reqClass)), TypeToken.of(Objects.requireNonNull(respClass)));
    }
}

