/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.messaging.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.messaging.Channel;
import me.lucko.helper.messaging.ChannelAgent;
import me.lucko.helper.terminable.Terminable;

public final class MappedChannelReceiver<T, K, V>
implements Terminable {
    private final ChannelAgent<T> agent;
    private final Function<? super T, ? extends K> keyMapper;
    private final Function<? super T, ? extends V> valueMapper;
    private final MessageStore<K, V> messageStore;

    @Nonnull
    public static <T, K, V> MappedChannelReceiver<T, K, V> createExpiring(@Nonnull Channel<T> channel, @Nonnull Function<? super T, ? extends K> keyMapper, @Nonnull Function<? super T, ? extends V> valueMapper, long expiryDuration, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(keyMapper, "keyMapper");
        Objects.requireNonNull(unit, "unit");
        return new MappedChannelReceiver<T, K, V>(channel, keyMapper, valueMapper, new CacheMessageStore(expiryDuration, unit));
    }

    @Nonnull
    public static <T, K> MappedChannelReceiver<T, K, T> createExpiring(@Nonnull Channel<T> channel, @Nonnull Function<? super T, ? extends K> keyMapper, long expiryDuration, @Nonnull TimeUnit unit) {
        return new MappedChannelReceiver(channel, keyMapper, Function.identity(), new CacheMessageStore(expiryDuration, unit));
    }

    @Nonnull
    public static <T, K, V> MappedChannelReceiver<T, K, V> create(@Nonnull Channel<T> channel, @Nonnull Function<? super T, ? extends K> keyMapper, @Nonnull Function<? super T, ? extends V> valueMapper, Map<K, V> map) {
        Objects.requireNonNull(channel, "channel");
        Objects.requireNonNull(keyMapper, "keyMapper");
        Objects.requireNonNull(valueMapper, "valueMapper");
        Objects.requireNonNull(map, "map");
        return new MappedChannelReceiver<T, K, V>(channel, keyMapper, valueMapper, new MapMessageStore(map));
    }

    @Nonnull
    public static <T, K> MappedChannelReceiver<T, K, T> create(@Nonnull Channel<T> channel, @Nonnull Function<? super T, ? extends K> keyMapper, Map<K, T> map) {
        return MappedChannelReceiver.create(channel, keyMapper, Function.identity(), map);
    }

    private MappedChannelReceiver(Channel<T> channel, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper, MessageStore<K, V> messageStore) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.messageStore = messageStore;
        this.agent = channel.newAgent(this::handleMessage);
    }

    private void handleMessage(ChannelAgent<T> agent, T message) {
        K key = this.keyMapper.apply(message);
        V value = this.valueMapper.apply(message);
        this.messageStore.put(key, value);
    }

    @Nonnull
    public Map<K, V> asMap() {
        return this.messageStore.asMap();
    }

    @Nullable
    public V getValue(@Nonnull K key) {
        return this.messageStore.getValue(key);
    }

    public void invalidateEntry(@Nonnull K key) {
        this.messageStore.invalidateEntry(key);
    }

    @Override
    public void close() {
        this.agent.close();
    }

    private static final class MapMessageStore<K, V>
    implements MessageStore<K, V> {
        private final Map<K, V> map;
        private final Map<K, V> asMap;

        private MapMessageStore(Map<K, V> map) {
            this.map = map;
            this.asMap = Collections.unmodifiableMap(this.map);
        }

        @Override
        public void put(K key, V message) {
            this.map.put(key, message);
        }

        @Override
        public Map<K, V> asMap() {
            return this.asMap;
        }

        @Override
        public V getValue(K key) {
            return this.map.get(key);
        }

        @Override
        public void invalidateEntry(K key) {
            this.map.remove(key);
        }
    }

    private static final class CacheMessageStore<K, V>
    implements MessageStore<K, V> {
        private final Cache<K, V> cache;
        private final Map<K, V> asMap;

        CacheMessageStore(long expiryDuration, TimeUnit unit) {
            this.cache = CacheBuilder.newBuilder().expireAfterWrite(expiryDuration, unit).build();
            this.asMap = Collections.unmodifiableMap(this.cache.asMap());
        }

        @Override
        public void put(K key, V message) {
            this.cache.put(key, message);
        }

        @Override
        public Map<K, V> asMap() {
            return this.asMap;
        }

        @Override
        public V getValue(K key) {
            return (V)this.cache.getIfPresent(key);
        }

        @Override
        public void invalidateEntry(K key) {
            this.cache.invalidate(key);
        }
    }

    private static interface MessageStore<K, T> {
        public void put(K var1, T var2);

        public Map<K, T> asMap();

        public T getValue(K var1);

        public void invalidateEntry(K var1);
    }
}

