/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.metadata;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.lucko.helper.metadata.TransientValue;

public class ExpireAfterAccessValue<T>
implements TransientValue<T> {
    private final T value;
    private final long millis;
    private long expireAt;

    public static <T> ExpireAfterAccessValue<T> of(T value, long duration, TimeUnit unit) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"duration must be >= 0");
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(unit, "unit");
        long millis = unit.toMillis(duration);
        return new ExpireAfterAccessValue<T>(value, millis);
    }

    public static <T> Supplier<ExpireAfterAccessValue<T>> supplied(Supplier<? extends T> supplier, long duration, TimeUnit unit) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0, (Object)"duration must be >= 0");
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(unit, "unit");
        long millis = unit.toMillis(duration);
        return () -> {
            Object value = supplier.get();
            Objects.requireNonNull(value, "value");
            return new ExpireAfterAccessValue(value, millis);
        };
    }

    private ExpireAfterAccessValue(T value, long millis) {
        this.value = value;
        this.millis = millis;
        this.expireAt = System.currentTimeMillis() + this.millis;
    }

    @Override
    @Nullable
    public T getOrNull() {
        if (this.shouldExpire()) {
            return null;
        }
        this.expireAt = System.currentTimeMillis() + this.millis;
        return this.value;
    }

    @Override
    public boolean shouldExpire() {
        return System.currentTimeMillis() > this.expireAt;
    }
}

