/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.network.modules;

import javax.annotation.Nonnull;
import me.lucko.helper.eventbus.EventBus;
import me.lucko.helper.eventbus.Subscribers;
import me.lucko.helper.network.Network;
import me.lucko.helper.network.event.NetworkEvent;
import me.lucko.helper.network.event.ServerConnectEvent;
import me.lucko.helper.network.event.ServerDisconnectEvent;
import me.lucko.helper.terminable.TerminableConsumer;
import me.lucko.helper.terminable.module.TerminableModule;
import me.lucko.helper.utils.Players;
import org.bukkit.command.CommandSender;

public class NetworkStatusModule
implements TerminableModule {
    private final Network network;

    public NetworkStatusModule(Network network) {
        this.network = network;
    }

    @Override
    public void setup(@Nonnull TerminableConsumer consumer) {
        EventBus<NetworkEvent> bus = this.network.getEventBus();
        Subscribers.register(bus, ServerConnectEvent.class, event -> NetworkStatusModule.broadcast("&7[&anetwork&7] &b" + event.getId() + " &7connected.")).bindWith(consumer);
        Subscribers.register(bus, ServerDisconnectEvent.class, event -> {
            if (event.getReason() != null && !event.getReason().isEmpty()) {
                NetworkStatusModule.broadcast("&7[&anetwork&7] &b" + event.getId() + " &7disconnected. (reason: " + event.getReason() + ")");
            } else {
                NetworkStatusModule.broadcast("&7[&anetwork&7] &b" + event.getId() + " &7disconnected. (reason unknown)");
            }
        }).bindWith(consumer);
    }

    private static void broadcast(String message) {
        Players.stream().filter(p -> p.hasPermission("helper.networkstatus.alerts")).forEach(p -> Players.msg((CommandSender)p, message));
    }
}

