/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.random;

import com.flowpowered.math.GenericMath;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface VariableAmount {
    @Nonnull
    public static VariableAmount fixed(double value) {
        return new Fixed(value);
    }

    @Nonnull
    public static VariableAmount range(double min, double max) {
        return new BaseAndAddition(min, VariableAmount.fixed(max - min));
    }

    @Nonnull
    public static VariableAmount baseWithVariance(double base, double variance) {
        return new BaseAndVariance(base, VariableAmount.fixed(variance));
    }

    @Nonnull
    public static VariableAmount baseWithVariance(double base, @Nonnull VariableAmount variance) {
        return new BaseAndVariance(base, variance);
    }

    @Nonnull
    public static VariableAmount baseWithRandomAddition(double base, double addition) {
        return new BaseAndAddition(base, VariableAmount.fixed(addition));
    }

    @Nonnull
    public static VariableAmount baseWithRandomAddition(double base, @Nonnull VariableAmount addition) {
        return new BaseAndAddition(base, addition);
    }

    @Nonnull
    public static VariableAmount baseWithOptionalVariance(double base, double variance, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithVariance(base, variance));
    }

    @Nonnull
    public static VariableAmount baseWithOptionalVariance(double base, @Nonnull VariableAmount variance, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithVariance(base, variance));
    }

    @Nonnull
    public static VariableAmount baseWithOptionalAddition(double base, double addition, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithRandomAddition(base, addition));
    }

    @Nonnull
    public static VariableAmount baseWithOptionalAddition(double base, @Nonnull VariableAmount addition, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithRandomAddition(base, addition));
    }

    public double getAmount(@Nonnull Random var1);

    default public double getAmount() {
        return this.getAmount(ThreadLocalRandom.current());
    }

    default public int getFlooredAmount(@Nonnull Random random) {
        return GenericMath.floor(this.getAmount(random));
    }

    default public int getFlooredAmount() {
        return GenericMath.floor(this.getAmount());
    }

    public static final class OptionalAmount
    implements VariableAmount {
        private final double base;
        private final double chance;
        private final VariableAmount inner;

        OptionalAmount(double base, double chance, VariableAmount inner) {
            this.base = base;
            this.chance = chance;
            this.inner = inner;
        }

        @Override
        public double getAmount(@Nonnull Random random) {
            if (random.nextDouble() < this.chance) {
                return this.inner.getAmount(random);
            }
            return this.base;
        }

        public String toString() {
            return "VariableAmount.OptionalAmount(base=" + this.base + ", chance=" + this.chance + ", inner=" + this.inner + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OptionalAmount)) {
                return false;
            }
            OptionalAmount other = (OptionalAmount)o;
            return Double.compare(this.base, other.base) == 0 && Double.compare(this.chance, other.chance) == 0 && this.inner.equals(other.inner);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (int)(Double.doubleToLongBits(this.base) >>> 32 ^ Double.doubleToLongBits(this.base));
            result = result * 59 + (int)(Double.doubleToLongBits(this.chance) >>> 32 ^ Double.doubleToLongBits(this.chance));
            result = result * 59 + this.inner.hashCode();
            return result;
        }
    }

    public static final class BaseAndAddition
    implements VariableAmount {
        private final double base;
        private final VariableAmount addition;

        private BaseAndAddition(double base, VariableAmount addition) {
            this.base = base;
            this.addition = addition;
        }

        @Override
        public double getAmount(@Nonnull Random random) {
            return this.base + random.nextDouble() * this.addition.getAmount(random);
        }

        public String toString() {
            return "VariableAmount.BaseAndAddition(base=" + this.base + ", addition=" + this.addition + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseAndAddition)) {
                return false;
            }
            BaseAndAddition other = (BaseAndAddition)o;
            return Double.compare(this.base, other.base) == 0 && this.addition.equals(other.addition);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (int)(Double.doubleToLongBits(this.base) >>> 32 ^ Double.doubleToLongBits(this.base));
            result = result * 59 + this.addition.hashCode();
            return result;
        }
    }

    public static final class BaseAndVariance
    implements VariableAmount {
        private final double base;
        private final VariableAmount variance;

        private BaseAndVariance(double base, @Nonnull VariableAmount variance) {
            this.base = base;
            this.variance = variance;
        }

        @Override
        public double getAmount(@Nonnull Random random) {
            double var = this.variance.getAmount(random);
            return this.base + random.nextDouble() * var * 2.0 - var;
        }

        public String toString() {
            return "VariableAmount.BaseAndVariance(base=" + this.base + ", variance=" + this.variance + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseAndVariance)) {
                return false;
            }
            BaseAndVariance other = (BaseAndVariance)o;
            return Double.compare(this.base, other.base) == 0 && this.variance.equals(other.variance);
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (int)(Double.doubleToLongBits(this.base) >>> 32 ^ Double.doubleToLongBits(this.base));
            result = result * 59 + this.variance.hashCode();
            return result;
        }
    }

    public static final class Fixed
    implements VariableAmount {
        private final double amount;

        private Fixed(double amount) {
            this.amount = amount;
        }

        @Override
        public double getAmount(@Nonnull Random random) {
            return this.amount;
        }

        public String toString() {
            return "VariableAmount.Fixed(amount=" + this.getAmount() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fixed)) {
                return false;
            }
            Fixed other = (Fixed)o;
            return Double.compare(this.amount, other.amount) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (int)(Double.doubleToLongBits(this.amount) >>> 32 ^ Double.doubleToLongBits(this.amount));
            return result;
        }
    }
}

